/*
 * Decompiled with CFR 0.152.
 */
package pa3k;

import java.awt.Color;
import java.awt.Graphics2D;
import pa3k.AimingConfiguration;
import pa3k.CircleMoving;
import pa3k.Coloring;
import pa3k.Configurable;
import pa3k.Configuration;
import pa3k.EvasionConfiguration;
import pa3k.FastTronAimingConfiguration;
import pa3k.GlobalTracking;
import pa3k.Gun;
import pa3k.Log;
import pa3k.MCAimingConfiguration;
import pa3k.MonteCarlo;
import pa3k.Opponent;
import pa3k.OpponentCreator;
import pa3k.Position;
import pa3k.RandomMoving;
import pa3k.RobotModule;
import pa3k.SelfTracking;
import pa3k.Tracking;
import pa3k.TronAimingConfiguration;
import pa3k.WaveSurfingConfiguration;
import robocode.AdvancedRobot;
import robocode.BulletHitBulletEvent;
import robocode.BulletHitEvent;
import robocode.BulletMissedEvent;
import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;
import robocode.Robot;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;
import robocode.SkippedTurnEvent;
import robocode.WinEvent;
import robocode.util.Utils;

public class Quark
extends AdvancedRobot
implements Configurable,
OpponentCreator {
    protected RobotModule[] modules;
    protected Tracking tracking;
    protected Gun gun;
    protected CircleMoving moving;
    protected MonteCarlo mc;
    protected SelfTracking st;
    protected static EvasionConfiguration[] evasion = null;
    protected static AimingConfiguration[] aiming = null;
    protected EvasionConfiguration currentEvasion;
    protected AimingConfiguration currentAiming;
    protected static int roundCount = 0;

    public Quark() {
        ++roundCount;
        if (evasion == null) {
            evasion = new EvasionConfiguration[3];
            Quark.evasion[0] = new RandomMoving(false);
            Quark.evasion[1] = new RandomMoving(true);
            Quark.evasion[2] = new WaveSurfingConfiguration();
        }
        if (aiming == null) {
            aiming = new AimingConfiguration[3];
            Quark.aiming[0] = new MCAimingConfiguration();
            Quark.aiming[1] = new TronAimingConfiguration();
            Quark.aiming[2] = new FastTronAimingConfiguration();
        }
        this.st = new SelfTracking(this, 4);
        this.tracking = new GlobalTracking(this, this.st, this);
        this.mc = new MonteCarlo(this, this.tracking, this.st);
        this.currentAiming = (AimingConfiguration)this.chooseOne(aiming);
        this.currentEvasion = (EvasionConfiguration)this.chooseOne(evasion);
        this.currentAiming.apply(this, this);
        this.currentEvasion.apply(this, this);
        this.currentAiming.newRound();
        this.currentEvasion.newRound();
        this.tracking.setMoving(this.moving);
        this.tracking.setAimingConfiguration(this.currentAiming);
        this.tracking.setEvasiveConfiguration(this.currentEvasion);
        this.modules = new RobotModule[6];
        this.modules[0] = new Coloring(this, new Color(151, 151, 151), new Color(204, 204, 204), new Color(151, 151, 151), new Color(255, 255, 255), new Color(204, 204, 204));
        this.modules[1] = this.moving;
        this.modules[2] = this.st;
        this.modules[3] = this.tracking;
        this.modules[4] = this.mc;
        this.modules[5] = this.gun;
    }

    public Configuration chooseOne(Configuration[] configurationArray) {
        double d = 0.0;
        if (Utils.getRandom().nextInt(15) < roundCount) {
            int n = 0;
            for (int i = 1; i < configurationArray.length; ++i) {
                if (!(configurationArray[n].getRating() < configurationArray[i].getRating())) continue;
                n = i;
            }
            Log.log(2, "Selecting the best confuguration: " + configurationArray[n] + "(" + configurationArray[n].getRating() + ")");
            return configurationArray[n];
        }
        for (Configuration configuration : configurationArray) {
            double d2 = configuration.getRating();
            d += d2;
            Log.log(2, configuration + ": " + d2);
        }
        double d3 = Utils.getRandom().nextDouble() * d;
        Log.log(2, " random = " + d3);
        double d4 = 0.0;
        for (Configuration configuration : configurationArray) {
            if (!((d4 += configuration.getRating()) >= d3)) continue;
            return configuration;
        }
        return configurationArray[0];
    }

    public void onBulletMissed(BulletMissedEvent bulletMissedEvent) {
        this.tracking.bulletMissed(bulletMissedEvent);
    }

    public void onScannedRobot(ScannedRobotEvent scannedRobotEvent) {
        this.tracking.opponentScanned(scannedRobotEvent);
    }

    public void onHitByBullet(HitByBulletEvent hitByBulletEvent) {
        this.tracking.hitByBullet(hitByBulletEvent);
        this.currentEvasion.hit();
    }

    public void onBuletHitBullet(BulletHitBulletEvent bulletHitBulletEvent) {
        this.tracking.bulletHitBullet(bulletHitBulletEvent);
    }

    public void onBulletHit(BulletHitEvent bulletHitEvent) {
        this.tracking.bulletHit(bulletHitEvent);
        this.currentAiming.hit();
    }

    public void onHitRobot(HitRobotEvent hitRobotEvent) {
        this.moving.onHitRobot(hitRobotEvent);
        this.gun.hitRobot(this.tracking.getByName(hitRobotEvent.getName()));
        this.tracking.onHitRobot(hitRobotEvent);
    }

    public void onRobotDeath(RobotDeathEvent robotDeathEvent) {
        this.tracking.robotDeath(robotDeathEvent);
        this.gun.robotDeath(robotDeathEvent);
        this.mc.dumpData();
        this.currentAiming.dumpData();
        this.currentEvasion.dumpData();
    }

    public void onPaint(Graphics2D graphics2D) {
        RobotModule.onPaint(this.modules, graphics2D);
        Log.onPaint(graphics2D);
    }

    public void onSkippedTurn(SkippedTurnEvent skippedTurnEvent) {
        Log.log(1, "***********************************");
        Log.log(1, "Turn " + skippedTurnEvent.getTime() + " skipped!");
    }

    public void onWin(WinEvent winEvent) {
        this.mc.dumpData();
        this.currentAiming.dumpData();
        this.currentEvasion.dumpData();
    }

    public void run() {
        Log.myNameIs(this.getName());
        Position.setBattleField((Robot)this);
        Log.log(1, "Using  " + this.currentAiming);
        Log.log(1, "Using  " + this.currentEvasion);
        RobotModule.init(this.modules);
        this.setAdjustGunForRobotTurn(true);
        this.setAdjustRadarForGunTurn(true);
        this.setAdjustRadarForRobotTurn(true);
        while (true) {
            RobotModule.turn(this.modules);
            this.execute();
        }
    }

    @Override
    public Opponent createOpponent(String string, AdvancedRobot advancedRobot) {
        return new Opponent(string, advancedRobot, this.currentAiming.getSelfAiming(this, this, string), this.currentEvasion.getOpponentAiming(this, this, string));
    }

    @Override
    public MonteCarlo getMonteCarlo() {
        return this.mc;
    }

    @Override
    public SelfTracking getSelfTracking() {
        return this.st;
    }

    @Override
    public Tracking getTracking() {
        return this.tracking;
    }

    @Override
    public void setGun(Gun gun) {
        this.gun = gun;
    }

    @Override
    public void setMoving(CircleMoving circleMoving) {
        this.moving = circleMoving;
    }
}

