/*
 * Decompiled with CFR 0.152.
 */
package ola;

import java.util.Formatter;

public class Direction {
    private static final int FULL_TURN = 360;
    private static final double CLOSE_ENOUGH = 0.1;
    public static final double HALF_TURN = 180.0;
    private double direction;

    public Direction(double direction) {
        this.direction = direction;
        this.norm();
    }

    private void norm() {
        this.direction %= 360.0;
        if (this.direction < 0.0) {
            this.direction += 360.0;
        }
    }

    public Direction turn(double dir) {
        return new Direction(this.direction + dir);
    }

    public double getDegrees() {
        return this.direction;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        Formatter formatter = new Formatter(s);
        this.format(formatter);
        return s.toString();
    }

    protected void format(Formatter formatter) {
        formatter.format("%.2f\u00b0", this.direction);
    }

    public double difference(Direction other) {
        return this.direction - other.direction;
    }

    public boolean isClose(Direction other) {
        double closeEnough = 0.1;
        return this.isClose(other, closeEnough);
    }

    public boolean isClose(Direction other, double closeEnough) {
        double difference = Math.abs(this.difference(other));
        return difference < closeEnough;
    }

    public double compassDiff(Direction other) {
        double difference = this.difference(other);
        if (difference > 180.0) {
            difference -= 360.0;
        } else if (difference < -180.0) {
            difference += 360.0;
        }
        return difference;
    }
}

