/*
 * Decompiled with CFR 0.152.
 */
package wcsv.mega;

public class DamageTracker {
    private static double[] damageDone;
    private static double[] damageTaken;
    private static final double MAX_DIST = 800.0;
    private static final int BINS = 3;

    public static void init() {
        if (damageDone == null) {
            damageDone = new double[3];
        }
        if (damageTaken == null) {
            damageTaken = new double[3];
        }
        int i = 0;
        while (i < 3) {
            DamageTracker.damageTaken[i] = 1.0;
            DamageTracker.damageDone[i] = 1.0;
            ++i;
        }
    }

    public static void giveDamage(double damage, double distance) {
        int index = (int)Math.min(2.0, distance / 266.6666666666667);
        int i = 0;
        while (i < 3) {
            int n = i;
            damageDone[n] = damageDone[n] + damage / (double)(Math.abs(index - i) + 1);
            ++i;
        }
    }

    public static void takeDamage(double damage, double distance) {
        int index = (int)Math.min(2.0, distance / 266.6666666666667);
        int i = 0;
        while (i < 3) {
            int n = i;
            damageTaken[n] = damageTaken[n] + damage / (double)(Math.abs(index - i) + 1);
            ++i;
        }
    }

    public static double getBestDistance(double currDist) {
        int index = (int)Math.min(2.0, currDist / 266.6666666666667);
        double delta = 266.6666666666667;
        int best = 1;
        double bestRatio = damageDone[best] / damageTaken[best];
        int i = 0;
        while (i < 3) {
            double ratio = damageDone[i] / damageTaken[i];
            if (ratio > bestRatio) {
                best = i;
                bestRatio = ratio;
            }
            ++i;
        }
        if (best > index) {
            return currDist + delta;
        }
        if (best < index) {
            return currDist - delta;
        }
        return currDist;
    }

    public static double getBestDistance() {
        double delta = 266.6666666666667;
        int best = 1;
        double bestRatio = damageDone[best] / damageTaken[best];
        int i = 0;
        while (i < 3) {
            double ratio = damageDone[i] / damageTaken[i];
            if (ratio > bestRatio) {
                best = i;
                bestRatio = ratio;
            }
            ++i;
        }
        return (double)(best + 1) * delta;
    }
}

