/*
 * Decompiled with CFR 0.152.
 */
package techdude.forest;

import robocode.ScannedRobotEvent;
import techdude.forest.Coordinate;
import techdude.forest.FlamingForest;
import techdude.forest.Pattern;
import techdude.forest.TechDudeRecord;
import techdude.forest.TechDudeRecordCollection;

class TechDudeMath {
    public static final double MAX_SPEED = 8.0;
    public static final double MIN_SPEED = 0.0;

    public static final double determineShotVelocity(double in_power) {
        return 20.0 - (double)3 * in_power;
    }

    public static final double determineCurvedShotAngle(FlamingForest in_owner, TechDudeRecord in_target, double in_velocity) {
        TechDudeRecordCollection collection = (TechDudeRecordCollection)FlamingForest.m_scannedInformation.get(in_target.getName());
        if (collection != null && collection.getInformationCount() >= 2 && collection.get(0).getDirection() == collection.get(1).getDirection()) {
            Pattern movePattern = collection.getPattern();
            double currentDistance = TechDudeMath.getDistanceToXYCoord(in_target.getX(), in_target.getY(), in_owner);
            double currentTime = currentDistance / in_velocity;
            Coordinate estimatedPosition = movePattern.estimatePosition(in_target.getX(), in_target.getY(), in_target.getVelocity(), currentTime, in_target.getAngle(), collection);
            if (estimatedPosition == null) {
                return Double.NaN;
            }
            double estimatedDistance = TechDudeMath.getDistanceToXYCoord(estimatedPosition.getX(), estimatedPosition.getY(), in_owner);
            int loopCounter = 0;
            while (Math.abs(estimatedDistance - currentDistance) > (double)3 && loopCounter < 10) {
                currentDistance = estimatedDistance;
                currentTime = currentDistance / in_velocity;
                estimatedPosition = movePattern.estimatePosition(in_target.getX(), in_target.getY(), in_target.getVelocity(), currentTime, in_target.getAngle(), collection);
                if (estimatedPosition == null) {
                    return Double.NaN;
                }
                estimatedDistance = TechDudeMath.getDistanceToXYCoord(estimatedPosition.getX(), estimatedPosition.getY(), in_owner);
                ++loopCounter;
            }
            double theta = Math.atan(Math.abs(in_owner.getX() - estimatedPosition.getX()) / Math.abs(in_owner.getY() - estimatedPosition.getY()));
            if (in_owner.getX() >= estimatedPosition.getX() && in_owner.getY() >= estimatedPosition.getY()) {
                theta = Math.PI + theta;
            } else if (in_owner.getX() >= estimatedPosition.getX() && in_owner.getY() < estimatedPosition.getY()) {
                theta = Math.PI * 2 - theta;
            } else if (in_owner.getX() < estimatedPosition.getX() && in_owner.getY() >= estimatedPosition.getY()) {
                theta = Math.PI - theta;
            } else {
                boolean bl = false;
                if (in_owner.getX() < estimatedPosition.getX() && in_owner.getY() < estimatedPosition.getY()) {
                    bl = true;
                }
            }
            return theta;
        }
        return Double.NaN;
    }

    public static double factorLife(double in_shotPower, double in_life) {
        if (in_shotPower * (double)4 > in_life) {
            return in_life / (double)4;
        }
        return in_shotPower;
    }

    public static final double normalAbsoluteAngle(double in_angle) {
        if (in_angle < 0.0) {
            return Math.PI * 2 + in_angle % (Math.PI * 2);
        }
        if (in_angle >= Math.PI * 2) {
            return in_angle % (Math.PI * 2);
        }
        return in_angle;
    }

    public static final double normalAbsoluteAngleRadians(double in_angle) {
        double wholeCircle = Math.PI * 2;
        if (in_angle < 0.0) {
            return wholeCircle + in_angle % wholeCircle;
        }
        if (in_angle >= wholeCircle) {
            return in_angle % wholeCircle;
        }
        return in_angle;
    }

    public static final double normalRelativeAngle(double angle) {
        double mod = angle % (Math.PI * 2);
        if (mod <= -Math.PI) {
            return Math.PI + mod % Math.PI;
        }
        if (mod > Math.PI) {
            return -Math.PI + mod % Math.PI;
        }
        return mod;
    }

    public static TechDudeRecord convertSCEToTechDudeRecord(ScannedRobotEvent in_event, FlamingForest in_robot) {
        TechDudeRecord out_TechDudeRecord = new TechDudeRecord(in_robot);
        TechDudeRecordCollection col = (TechDudeRecordCollection)FlamingForest.m_scannedInformation.get(in_event.getName());
        double enemyDirection = in_robot.getHeadingRadians() + in_event.getBearingRadians();
        double distance = in_event.getDistance();
        double distanceX = Math.sin(enemyDirection) * distance;
        double distanceY = Math.cos(enemyDirection) * distance;
        short direction = -1;
        direction = in_event.getVelocity() < 0.0 ? (short)-1 : (in_event.getVelocity() > 0.0 ? (short)1 : (in_event.getVelocity() == 0.0 && col != null && col.isCurrent() ? (short)col.get(0).getDirection() : (short)1));
        out_TechDudeRecord.setName(in_event.getName());
        out_TechDudeRecord.setLife(in_event.getEnergy());
        out_TechDudeRecord.setAngle(in_event.getHeadingRadians());
        out_TechDudeRecord.setBearing(in_event.getBearingRadians());
        out_TechDudeRecord.setDistance(in_event.getDistance());
        out_TechDudeRecord.setVelocity(in_event.getVelocity());
        out_TechDudeRecord.setDirection(direction);
        out_TechDudeRecord.setCoordinate(new Coordinate(distanceX + in_robot.getX(), distanceY + in_robot.getY()));
        out_TechDudeRecord.setRoundNum(in_robot.getRoundNum());
        return out_TechDudeRecord;
    }

    public static double getDistanceToXYCoord(double in_x, double in_y, FlamingForest in_owner) {
        return Math.sqrt(Math.pow(in_y - in_owner.getY(), 2) + Math.pow(in_x - in_owner.getX(), 2));
    }

    public static double getAngleToXYCoord(double in_x, double in_y, FlamingForest in_owner) {
        double theta = -1.0;
        double currentX = in_owner.getX();
        double currentY = in_owner.getY();
        theta = Math.atan(Math.abs(currentX - in_x) / Math.abs(currentY - in_y));
        if (currentX >= in_x && currentY >= in_y) {
            theta = Math.PI + theta;
        } else if (currentX >= in_x && currentY < in_y) {
            theta = Math.PI * 2 - theta;
        } else if (currentX < in_x && currentY >= in_y) {
            theta = Math.PI - theta;
        } else {
            boolean bl = false;
            if (currentX < in_x && currentY < in_y) {
                bl = true;
            }
        }
        if (in_owner.m_direction == -1) {
            return TechDudeMath.normalRelativeAngle(theta - TechDudeMath.normalAbsoluteAngle(in_owner.getHeadingRadians() + Math.PI));
        }
        return TechDudeMath.normalRelativeAngle(theta - in_owner.getHeadingRadians());
    }

    public static double getAngleToXYCoord(Coordinate in_coord, FlamingForest in_owner) {
        return TechDudeMath.getAngleToXYCoord(in_coord.getX(), in_coord.getY(), in_owner);
    }

    public static double getAngleToXYCoordExcludeFacing(double in_x, double in_y, FlamingForest in_owner) {
        double theta = -1.0;
        double currentX = in_owner.getX();
        double currentY = in_owner.getY();
        theta = Math.atan(Math.abs(currentX - in_x) / Math.abs(currentY - in_y));
        if (currentX >= in_x && currentY >= in_y) {
            theta = Math.PI + theta;
        } else if (currentX >= in_x && currentY < in_y) {
            theta = Math.PI * 2 - theta;
        } else if (currentX < in_x && currentY >= in_y) {
            theta = Math.PI - theta;
        } else {
            boolean bl = false;
            if (currentX < in_x && currentY < in_y) {
                bl = true;
            }
        }
        return theta;
    }

    public static void turnToXYCoord(Coordinate in_coord, FlamingForest in_owner) {
        double angle = TechDudeMath.getAngleToXYCoord(in_coord, in_owner);
        if (angle > 1.5707963267948966) {
            in_owner.reverseDirection();
            in_owner.setTurnLeftRadians(Math.PI - angle);
        } else if (angle < -1.5707963267948966) {
            in_owner.reverseDirection();
            in_owner.setTurnRightRadians(Math.PI - Math.abs(angle));
        } else {
            in_owner.setTurnRightRadians(angle);
        }
    }

    private TechDudeMath() {
    }
}

