package ags.muse.recon.events;

import robocode.Event;
import ags.util.points.*;

public abstract class ReconEvent extends Event {
    private static final long serialVersionUID = 1L;

    // Stored data
    private final String        name;
    private final AbsolutePoint location;
    private final RelativePoint velocity;
    private final double        energy; 

    // Getters
    public String        getName()     { return name; }
    public AbsolutePoint getLocation() { return location; }
    public RelativePoint getVelocity() { return velocity; }
    public double        getEnergy()   { return energy; }

    // Constructor
    public ReconEvent(long time, String name, AbsolutePoint location, RelativePoint velocity, double energy) {
        this.setTime(time);
        this.name     = name;
        this.location = location;
        this.velocity = velocity;
        this.energy   = energy;
    }
}
