package m3thos;
import robocode.*;
import robocode.util.*;
import java.awt.geom.*;

import java.awt.Color;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.HashMap;


/**
 * Eva02 - a robot by Miguel Sousa Filipe
 *
 * Derived from Eva01 v0.5.5
 *.
 * Version 0.8
 * - antigravity
 * - new antiwall
 * - circular targeting
 * Version 0.7.
 * - lots of refactor
 * - new selectBestTarget criteria
 * - aim&file on main loop
 * - selectBestTarget on main loop
 * - new linear targeting algorithm
 * Version 0.6.
 * - keep track of all bots in battle
 * - keep record of robots between battles
 * Version 0.5.5 (codesize 1499)
 * - small bug fix
 * - change firepower calc
 * - changed package to m3thos.mini
 * Version 0.5.4 (not-released)
 * - based on 0.5.1 wich was the best.. but above the minibot class
 * - integrated v0.5.3 fixes and tunes
 * - other minor enhancements...
 * Version 0.5.3 (codesize: 1477)
 * - code restructure that reduced codesize
 * - "stuck in corners" bug fix v1
 * - fixes & tunes in target selection
 * Version 0.5.2	(codesize: 1489)
 * - attempt to make it a minibot
 * - rewrote some if's.
 * - and removed some not very important crap.
 * Version 0.5.1	(codesize: 1860)
 * - moved some randoms around, they were conflicting with the anti-wall
 * - bug fixing in anti-wall related code.
 * Version 0.5		(codesize: 2271)
 * - anti-wall implemented.
 * - target selection is now diferent, same strategy, diferent implementaion.
 * Version 0.4.3	(codesize: 1704)
 * - removal of unneeded code.
 * - general clean up.
 * - even more constant tweaking
 * Version 0.4.2:   (codesize: 2431)
 * - v0.4.1 had fireType selection badly corrected.
 * - another constant tweaking
 * Version 0.4.1:
 * - mutch enhanced firing code.
 * - Now only switches target if new target is considerably closer to us.
 * - Corrected some small bugs in code
 *
 * Geracao 2. Version 0.4
 * - acceptable firing algorithm, now with 2 types of firing.
 * - attack closer bots first.
 * - use random for unpredictability of movement.
 */
public class Eva02 extends AdvancedRobot
{
    static private final double HALF_PI = (Math.PI/2);
    static private final double DOUBLE_PI = (Math.PI*2);
    static private final int LINEAR = 0; // linear targeting, the most important one
    static private final int DIRECT = 1; // direct targeting, it's when linear is performing very bad.
    // eco targeting, used when both are bad performers, will shoot only half of the requests
    static private final int ECO = 2;
    static private final double SAFE = 48; 	// mimimal allowed distance to walls
    static private double _distWallBefore;		// distance from walls in the last run
    static private int _wallCount;		// counts successive runs of antiWall near the wall
	static private boolean _avoid = false;	// tells if we're avoid walls ATM
    static private boolean _avancar = true;  // ve if we are walking ahead or back
    static private double _dist = 300;       // distance used has reference in all movements
    static private int _hitWallCount = 0;
	private Memory _memory;
	private HashMap _enemies = new HashMap();
	private float _shotsFired = 0, _shotsHit = 0, _bulletHit = 0,
	_numEnemys = 0;

    /**
     * run: Eva02's default behavior isn't important.
     */
    public void run()
    {
        setColors(Color.green,Color.white,Color.white);
        _memory = new Memory(getDataFile("memory.dat"));
        setAdjustGunForRobotTurn(true);
        setAdjustRadarForGunTurn(true);
        setAdjustRadarForRobotTurn(true);
        setTurnRadarRightRadians( Double.POSITIVE_INFINITY );
		out.println("Eva02 v0.7!");
        Enemy evil = null; 
        while(true)
        {
	        doMovement(evil);
            execute();
            evil = sellectBestTarget(evil);
			pointAndShoot( evil );
            if( getOthers() > 1 ||
                 evil == null ||
                 (evil.getLastScan() + 5) < getTime() )
                setTurnRadarRightRadians( DOUBLE_PI );
            else 
                setTurnRadarRightRadians( Utils.normalRelativeAngle(evil.getBearing() - getRadarHeadingRadians()));
			execute();
        }
    }

    public void onScannedRobot(ScannedRobotEvent e)
    {
        Enemy enemy = getEnemy(e.getName());		
        enemy.updateEnemy(e, getX(), getY(), getHeadingRadians(), getTime());
    }

	public void onHitRobot(HitRobotEvent e) {
		setTurnGunTo(e.getBearingRadians());

		Enemy enemy = getEnemy(e.getName());
        enemy.updateEnemy(e, getTime());
        
		if( getGunHeat() == 0)
        {
            fire(3);
            enemy.incShots();
            _shotsFired++;
        }
	}

	public void onHitByBullet(HitByBulletEvent e) {
        Enemy enemy = getEnemy(e.getName());
		enemy.addInflictedShot(e.getPower());
		_bulletHit++;

        if (!_avoid && Math.random() < .5)
            setTurnPerpendicularTo(e.getBearingRadians());
        if (!_avoid && Math.random() < .13)
            reverseDirection();
	}

	public void onBulletHit(BulletHitEvent e) {
		Enemy enemy = getEnemy(e.getName());
        enemy.addHit(e.getBullet().getPower());
        _shotsHit++;
	}
	
// this should not happen since we now have a lame anti-wall thingie going on..
// but.. better safe than sorry :-p
    public void onHitWall(HitWallEvent e)
    {
        out.println("hit wall.");
        _hitWallCount++;
        _avoid = true;
		reverseDirection();
		_distWallBefore = distanceToWall();
    }
	
    public void onDeath(DeathEvent e)
    {
        printBattleStats();
        memorizeEnemies();
    }

    public void onRobotDeath(RobotDeathEvent e) 
    {
        String name = e.getName();
        out.println("DIED: "+name);

        Enemy enemy = (Enemy) _enemies.remove(name);
        if(enemy != null) {
            enemy.isDead = true;
            enemy.printFightStats();
            _memory.remmember(enemy);
        }

        if (getOthers() == 0) {
            memorizeEnemies();
            out.println("I WON!");
            printBattleStats();
            setTurnRight(Double.POSITIVE_INFINITY);
            stop();
        }
    }


    /***************************************************************************
     *               Auxiliary Functions/Methods                               *
     *   used by the main methods and event handlers                           *
     ***************************************************************************/

    private void pointAndShoot(Enemy e)
    {
        if( e == null )
            return;

        double bulletPower = e.calcFirePower(this.getEnergy());
        double myX = getX();
        double myY = getY();
        double absoluteBearing = e.getBearing();
        double enemyX = e.getX();
        double enemyY = e.getY();
        double enemyHeading = e.getHeading();
        double enemyVelocity = e.getSpeed();

        //out.println(e.getName()+" shoot1: X:"+(int)enemyX+"/Y:"+(int)enemyY);

        double deltaTime = 0;
        double battleFieldHeight = getBattleFieldHeight(), 
               battleFieldWidth = getBattleFieldWidth();
        double predictedX = enemyX, predictedY = enemyY;

        while((++deltaTime) * (20.0 - 3.0 * bulletPower) < Point2D.Double.distance(myX, myY, predictedX, predictedY))
        {     
            predictedX += Math.sin(enemyHeading) * enemyVelocity;   
            predictedY += Math.cos(enemyHeading) * enemyVelocity;
            if( predictedX < 18.0 
                    || predictedY < 18.0
                    || predictedX > battleFieldWidth - 18.0
                    || predictedY > battleFieldHeight - 18.0)
            {
                predictedX = Math.min(Math.max(18.0, predictedX), 
                        battleFieldWidth - 18.0);   
                predictedY = Math.min(Math.max(18.0, predictedY), 
                        battleFieldHeight - 18.0);
                break;
            }
        }
        double theta = Utils.normalAbsoluteAngle(Math.atan2(
                    predictedX - getX(), predictedY - getY()));

        setTurnGunRightRadians(Utils.normalRelativeAngle(theta - getGunHeadingRadians()));
        if( getGunHeat() == 0) {
            e.incShots();
            _shotsFired++;
            setFire(bulletPower);
        }
    }


    /** doMovement
     * 
     * implements anti-wall and in melee stays away from the center
     *
     */
    private void doMovement(Enemy e) {
        double direction;
        antiWall();
        if(!_avoid && e != null)
        {
            if(Math.random() < .08)
                reverseDirection();
            direction = e.getBearing() - getHeadingRadians();
        /* If the target is "too" far away, we will strive to get near him
         * if he's "close" we'll keep perpendicular to him.*/
            if(e.getDistance() > 300) // still experimenting with this value.
                direction += (( _avancar && direction < 0) ?  -Math.PI/5   
                                : (( _avancar || direction < 0)? Math.PI/5: -Math.PI/5));
            setTurnPerpendicularTo(direction);
        }
        setAhead(_dist);
    }
    
    private void antiWall() {
        double wall_dist;
        if ((wall_dist = distanceToWall()) < SAFE) {
            if (_wallCount++ > 20) {
                //out.println("Estou num canto.. vou tentar sair!");
                setTurnPerpendicularTo(getHeadingRadians());
                _wallCount = 0;
            }
            if (!_avoid && _distWallBefore > (_distWallBefore = wall_dist) ) {
                _avoid = true;
                reverseDirection();
            }
        } else {
            _wallCount = 0;
            _avoid = false;
        }
    }

	/**
	 * memorizeEnemies sends all memories to memory and asks it to remmember
	 * all.
	 */
	private void memorizeEnemies() {
		_memory.remmemberAll(_enemies.values());
		_memory.preserveMemory();
	}

	/**
	 * sellectBestTarget selects the best target fro the enemylist.
	 */
	public Enemy sellectBestTarget(Enemy current) 
    {
		Iterator iterador = _enemies.values().iterator();
        Enemy target = null;
		Enemy enemy;
		while (iterador.hasNext()) {
			enemy = (Enemy) iterador.next();
			//            out.println("comparing with: "+enemy.getName());
            if( target == null)
                target = enemy;
            else if (target.isBetterTarget(enemy))
				target = enemy;
		}

        if( target != null && (current == null || !current.getName().equals(target.getName()) ) )
            out.println("new target: "+target.getName());
        return target;
	}

	/**
	 * getEnemy gets the enemy with the given name.
     *  - first uses the list of current enemies,
     *  - if not there, fetch it from Memory...
	 */
	private Enemy getEnemy(String name) 
    {
        Enemy e = (Enemy) _enemies.get(name);
        if( e != null)
            return e;

        // not in enemylist, get it from memory and add it.
        out.println("fetch from mem: "+name);
        e = _memory.getEnemy(name);
        _enemies.put(name, e);
        return e;
	}
    
    
    private void printBattleStats()
    {

		Iterator iterador = _enemies.values().iterator();
		Enemy enemy;
		while (iterador.hasNext()) {
			enemy = (Enemy) iterador.next();
            enemy.printFightStats();
        }
        out.println("Fired, Hit: ("+_shotsFired+"/"+_shotsHit+")");
        out.println("I was hit "+_bulletHit+" times");
        out.println("GLOBAL Absolute target Hit Ratio: "+_shotsHit/_shotsFired);
        out.println("I hit the wall "+_hitWallCount +" times");

    }
    
    
    private void reverseDirection()
    {
        _dist *= -1;
        _avancar = ((_avancar)? false : true);
    }

    // yes.. it gives the distance from nearest wall.
	private double distanceToWall()
	{
		return Math.min(Math.min(getBattleFieldWidth() - getX(), getX()), Math.min(getBattleFieldHeight() - getY(),getY()));
	}

    public void setTurnTo( double angle)
    {
        if (Math.abs(angle) > HALF_PI)
        {
            reverseDirection();
            angle += Math.PI;
        }
        setTurnRightRadians(Utils.normalRelativeAngle(angle));
    }
    
    public void setTurnPerpendicularTo( double angle)
    {
        angle += ((angle > 0) ? -HALF_PI : HALF_PI);
        setTurnRightRadians(angle);
    }
    
    public void setTurnGunTo( double angle)
    {
        angle += getHeadingRadians() - getGunHeadingRadians();
        setTurnGunRightRadians(Utils.normalRelativeAngle(angle));
    }
    
}
