package kawigi.sbf;
import robocode.*;
import java.awt.geom.*;
import java.awt.*;
import java.util.Vector;
import java.io.*;
import java.util.zip.*;
/**
 * Teancum - FloodMini with a new type of gun.
 * -- v. 1.0 - first version
 * -- v. 1.1 - fixed movement bug
 * -- v. 1.2 - improved pattern-matcher, thanks to Vic Stewart's Pattern-matcher challenge.  Also re-tweaked movement, time will tell if it will be reverted.
 * -- v. 1.3 - put back the flood movement, might go back to the TeancumPassive movement, but I don't know.  Hasn't been well tested yet.  Just a tweak before the Final MiniBot showdown.
 * Squeezed, but I need to decide in the next version how to use the extra bytes still.
 */
public class Teancum extends AdvancedRobot
{
	static int currentDirection;
	static double currentEnergy;
	static int distanceindex;
	static int nextTime;
	static double[] benefit = new double[30], penalty = new double[30];
	static double[][] lateralv, advancev;
	static int index[];
	static int direction = 1;
	static int roundnum;
	
	public boolean out(double angle, double c)
	{
		return !(new Rectangle2D.Double(18, 18, getBattleFieldWidth()-36D,  getBattleFieldHeight()-36D)).contains(Math.sin(angle)*c+getX(), Math.cos(angle)*c+getY());
	}

	public void run()
	{
		if ((roundnum = getRoundNum()) == 0)
		{
			lateralv = new double[getNumRounds()][5000];
			advancev = new double[getNumRounds()][5000];
			index = new int[getNumRounds()];
		}
		index[roundnum] = 1;
		Color blue = Color.blue;
		setColors(blue, blue, blue);
		setAdjustGunForRobotTurn(true);
		turnRadarRight(Double.POSITIVE_INFINITY);
	}
	
	public void onScannedRobot(ScannedRobotEvent e)
	{
		double distance = e.getDistance();
		distanceindex = (int)(distance/50);
		setTurnRadarLeft(getRadarTurnRemaining());
		double denergy;
		nextTime--;
		if ((denergy = currentEnergy-(currentEnergy = e.getEnergy())) > 0 && denergy <= 3)
		{
			benefit[distanceindex] += denergy;
			if (0 >= nextTime)
			{
				setMaxVelocity(2+20*Math.random());
				currentDirection = (Math.random() < .5)?-30:30;
				nextTime = (int)(distance/(40-6*denergy));
			}
		}
		
		int rel = 90;
		if (distance < findDistanceBracket()-120)
			rel = 90+currentDirection;
		double absbearing;
		if (out(Math.PI+(absbearing = getHeadingRadians()+e.getBearingRadians()), 50) || distance > findDistanceBracket() || getEnergy()/currentEnergy >= 7 || closeToCorner())
			rel = 90-currentDirection;
		if (nextTime < distance/-11 && currentEnergy == 0)
			rel = 90-currentDirection*3;
		setTurnRight(e.getBearing()-rel);
		if (out(getHeadingRadians(),currentDirection))
			currentDirection = -currentDirection;
		setAhead(currentDirection);
		
		double latvel = Math.sin(e.getHeadingRadians()-absbearing)*e.getVelocity();
		double advvel = -Math.cos(e.getHeadingRadians()-absbearing)*e.getVelocity();
		long dtime, time;
		double dlat = (latvel-lateralv[roundnum][index[roundnum]-1])/(dtime = (time = getTime())-index[roundnum]+1);
		double dadv = (advvel-advancev[roundnum][index[roundnum]-1])/dtime;
		while (index[roundnum] <= time)
		{
			index[roundnum]++;
			lateralv[roundnum][index[roundnum]] = lateralv[roundnum][index[roundnum]-1]+dlat;
			advancev[roundnum][index[roundnum]] = advancev[roundnum][index[roundnum]-1]+dadv;
		}
		
		if (getGunHeat() <= 2*getGunCoolingRate() && currentEnergy*getEnergy()>0)
		{
			int matchsize = Math.min(index[roundnum], 20);
			double bestdeviation = Double.POSITIVE_INFINITY;
			double bestdeviationdirection=1;
			int bestindex = 0, bestround = 0, round = Math.max(roundnum-30, 0);
			do
			{
				int i=0;
				do
				{
					double deviation=0;
					double negdeviation=0;
					int j=0;
					do
					{
						deviation += Math.abs(lateralv[round][j+i]-lateralv[roundnum][index[roundnum]-matchsize+j]) + Math.abs(advancev[round][j+i]-advancev[roundnum][index[roundnum]-matchsize+j]);
						negdeviation += Math.abs(lateralv[round][j+i]+lateralv[roundnum][index[roundnum]-matchsize+j]) + Math.abs(advancev[round][j+i]+advancev[roundnum][index[roundnum]-matchsize+j]);
						j++;
						if (deviation > bestdeviation && negdeviation > bestdeviation)
							break;
					}
					while (j < matchsize);
					if (deviation < bestdeviation)
					{
						bestdeviation = deviation;
						bestdeviationdirection = 1;
						bestindex = i;
						bestround = round;
					}
					if (negdeviation < bestdeviation)
					{
						bestdeviation = negdeviation;
						bestdeviationdirection = -1;
						bestindex = i;
						bestround = round;
					}
					i++;
				}
				while (i<index[round]-distance/10-matchsize);
				round++;
			}
			while (round <= roundnum);
			double power = Math.min(Math.min(getEnergy(), currentEnergy)/4, 3);
			bestindex += matchsize;
			double bulletv = 20-3*power;
			double bulletd = -bulletv;
			do
			{
				bestindex++;
				time++;
				distance -= advancev[bestround][bestindex];
				absbearing += bestdeviationdirection*Math.asin(lateralv[bestround][bestindex]/distance);
				bulletd += bulletv;
				if (out(absbearing, distance))
				{
					//this code would have assumed my opponent will bounce off the wall:
					//bestdeviationdirection = -bestdeviationdirection;
					//absbearing += 2*bestdeviationdirection*Math.asin(lateralv[bestround][bestindex]/distance);
					//adjust power to hit him when he hits the wall:
					power = Math.max((20-distance/bulletd*bulletv)/3, .1);
					break;
				}
			}
			while (bulletd < distance && bestindex+1 < lateralv[bestround].length);
			setTurnGunRightRadians(robocode.util.Utils.normalRelativeAngle(absbearing-getGunHeadingRadians()));
			if (Math.abs(getGunTurnRemaining()) < 10)
			{
				setFire(power);
				penalty[distanceindex] += power;
			}
		}
		else
			setTurnGunRightRadians(robocode.util.Utils.normalRelativeAngle(absbearing-getGunHeadingRadians()));
	}

	private boolean closeToCorner()
	{
		int i=0;
		do
		{
			if (Point2D.distance(getX(), getY(), (i&1)*getBattleFieldWidth(), (i>>1)*getBattleFieldHeight())<200)
				return true;
			i++;
		}
		while (i < 4);
		return false;
	}
	
	public void onHitByBullet(HitByBulletEvent e)
	{
		double power = e.getPower();
		currentEnergy += power*3;
		penalty[distanceindex] += Math.max(power*7, power*9-2);
	}
	
	public void onBulletHit(BulletHitEvent e)
	{
		double power = e.getBullet().getPower();
		double damage;
		currentEnergy -= (damage = Math.max(4*power, 6*power-2));
		benefit[distanceindex] += damage+power*3;
	}
	
	public int findDistanceBracket()
	{
		int bestindex;
		int i = bestindex = 4;
		do
		{
			if (findBenefit2(i) > findBenefit2(bestindex))
				bestindex = i;
			i++;
		}
		while (i <= 12);
		return bestindex*50+85;
	}
	
	public double findBenefit2(int index)
	{
		return 2*findBenefit(index)+findBenefit(index-1)+findBenefit(index+1);
	}
	
	public double findBenefit(int index)
	{
		return (benefit[index]-penalty[index])/(benefit[index]+penalty[index]);
	}
}