package tobe.guns;
import tobe.util.*;
import tobe.statistics.*;
import robocode.*;
import java.util.List;
import tobe.platform.*;

	public class MicroLaser implements Gun{
		
		public Aim aim(CommandCentre cc) {
			AdvancedRobot bot = cc.getBot();
			if(target == null) target = cc.getPreferredTarget();
			if(target == null) return null;
			if(!target.isSeen()) {
				reset();
				target = cc.getPreferredTarget();
			}
			if(target == null) return null;
			CircularArray evasions = target.getEvasions();
			v.setVector(target.getPosition());
			v.changeOrigin(bot.getX(), bot.getY());
			double shotPower = Math.min(3,bot.getEnergy()-5.0);
			if(shotPower < 0.5) shotPower = Math.min(0.5, bot.getEnergy()-0.1);
	/*testing*/		shotPower = (v.getDistance() < 500 ? shotPower : Math.min(0.1, shotPower));
			shotPower = (target.getEnergy() > 0 ? shotPower : 0.1);
			if(shotPower < 0.1) return null;
			double bulletVelocity = (20-3*shotPower);
			//targetting here
			if(evasions.size() > 0 && target.getEnergy() > 0) {
				//if( chosenEvasion == null) {
					int k = evasions.size()-((int) random.nextDouble()*Math.min(8,evasions.size()));
					chosenEvasion = (Evasion) evasions.get(k-1);
				//}
				//time method, should be better in melee when scans are old
				double bulletTime = v.getDistance()/bulletVelocity;
				double delay = bot.getTime()-target.getTime();
				double targetVelocity = chosenEvasion.getVelocity();
				//no good so far: double targetVelocity = chosenEvasion.getVelocityRelativeVelocity(target.getAverageVelocity());
				//the angular velocity thing was only good against very spiral bots
				//double angularVelocity = chosenEvasion.getAngularVelocity();
				//v.add(target.getHeading()+angularVelocity*(bulletTime+delay), targetVelocity*(bulletTime+delay));
				v.add(chosenEvasion.getHeadingRelativeHeading()+target.getHeading(), targetVelocity*(bulletTime+delay));
				v.changeOrigin(bot.getX(), bot.getY());
				bulletVelocity = v.getDistance()/bulletTime;
				shotPower = (20-bulletVelocity)/3;
				shotPower = Math.max(0.1,Math.min(3,shotPower));
				/*sines method
				double impactBearing = v.getBearing();//just go for a straight shot
				double distance = v.getDistance();
				double angle = BearingVector.normalizeAngle(chosenEvasion.getHeadingRelativeHeading()+target.getHeading()-impactBearing);
				//use the fact that in a triangle, side/sin(opposite angle) is the same for all 3 sides
				double shotAngle = Math.asin(chosenEvasion.getVelocity()/bulletVelocity*Math.sin(angle));
				impactBearing += shotAngle;
				//sum of angles in a triangle is PI
				double complementAngle = BearingVector.normalizeAngle(Math.PI - angle - shotAngle);
				//use the fact that in a triangle, side/sin(opposite angle) is the same for all 3 sides
				distance = distance*Math.sin(angle)/Math.sin(complementAngle);
				v.setPolar(impactBearing, distance);
				*/
			}
			double m = bot.getWidth()*0.8;
			double h = cc.getPlayingField().getHeight();
			double w = cc.getPlayingField().getWidth();
			double x = Math.min(w-m,Math.max(m,v.getToX()));
			double y = Math.min(h-m,Math.max(m,v.getToY()));
			v.setPoints(x,y,bot.getX(), bot.getY());
			return new Aim(v.getBearing(), Math.atan(bot.getWidth()/2/v.getDistance()), shotPower);
		}
		
		public void reset() {
			chosenEvasion = null;
			target = null;
		}
	
	//variables
		private BearingVector v = new BearingVector();//for calculations
		private java.util.Random random = new java.util.Random();
		private Evasion chosenEvasion;//to keep aiming "the same shot"
		private TargetStatistics target;
	}
	