package brainfade.utils;
import robocode.*;
import java.util.*;
import java.io.*;

public class Score implements Serializable, Comparable
{    
   
    public double bounceVal;
    
    public Score() 
    {
        
    }
    
    public double enemyEnergy;
    public double myEnergy;
    public String enemyName;
    
    public double[] bullet = new double[2];
    public double[] curbullet = new double[2];
    public double[] survival = new double[2];
    
    public void onScannedRobot(ScannedRobotEvent e, AdvancedRobot robot) 
    {
        myEnergy = robot.getEnergy();
        enemyEnergy = e.getEnergy();
        if (enemyName == null) enemyName = e.getName();
    }
    
    public void onBulletHit(BulletHitEvent e) 
    {
        if (e.getEnergy() < 0.001) return; //ignore if enemy dead
        curbullet[0] += 4 * e.getBullet().getPower() + 2 * Math.max(e.getBullet().getPower() - 1, 0);
    }
    
    public void onHitByBullet(HitByBulletEvent e) 
    {
        if (e.getPower() * 4 + Math.max(0, e.getPower() - 1) * 2 > myEnergy) return;  
        curbullet[1] += 4 * e.getBullet().getPower() + 2 * Math.max(e.getBullet().getPower() - 1, 0);
    }
    
    public void onWin(WinEvent e) 
    {
        survival[0] += 60;
        curbullet[0] += enemyEnergy;
        bullet[0] += curbullet[0] * 1.2;
        bullet[1] += curbullet[1];
        curbullet[0] = 0; curbullet[1] = 0;
    }
    
    public void onDeath(DeathEvent e) 
    {
        survival[1] += 60;
        curbullet[1] += myEnergy;
        bullet[0] += curbullet[0];
        bullet[1] += curbullet[1] * 1.2;
        curbullet[0] = 0; curbullet[1] = 0;
    }
  
    /** returns the score of the requested robot: 0=self, 1=enemy */
    public int getScore(int id) 
    {
        return (int)Math.round(bullet[id] + curbullet[id] + survival[id]);
    }
    
    public double getRatio()
    {
        System.out.println("MY SCORE: " + getScore(0));
        System.out.println("THEIR SCORE: " + getScore(1));
        return getScore(0)/getScore(1);
    }
    
    public int compareTo(Object o) 
    {	//allows us to use Collections.max (note 'implements comparable' above)
        //Guess second = (Guess) o;
        //if (this.value < ((Guess)o).value) return -1;
        //if (this.value > ((Guess)o).value) return  1;
        
        return new Double(this.getRatio()).compareTo(new Double(((Score)o).getRatio()));  // 0;  saves 6 bytes on the above code
    }
    
}