package theo.simple.radar;
import theo.simple.enemy.Enemy;
import robocode.*;
import robocode.util.*;
/**
 * Radar - a class by Damij
 */
public class Radar
{

	AdvancedRobot bot;
	Enemy enemy;
	
	long sweepTime = 0;
	
	public Radar (AdvancedRobot bot){
		this.bot = bot;
	}
	
	public void update(Enemy enemy, ScannedRobotEvent e){
		this.enemy = enemy;
		double radarOffset = enemy.absAngle - bot.getRadarHeadingRadians();
		radarOffset = 2*Utils.normalRelativeAngle(radarOffset);
		if((bot.getTime()-this.sweepTime<30 && bot.getTime()-this.sweepTime>3) || this.bot.getOthers() == 1){
			bot.setTurnRadarRightRadians(radarOffset);
		}
		else{
			bot.setTurnRadarRightRadians(2*Math.PI);
			sweepTime = bot.getTime();
		}
	}

}
