package pi.mouvement;

import java.util.*;
import pi.*;
public abstract class MouvementMode
{
double p=Math.PI;
public int etat;
MasterBot monRobot;
Vector informations;
abstract void doMouvement();

public static boolean compareMode(MouvementMode a,MouvementMode b)
	{
	if(b==null) return true;
	else
		{
		if(a instanceof Oscillatoire && b instanceof Oscillatoire) return false;
		if(a instanceof Defensif && b instanceof Defensif) return false;
		if(a instanceof EviterMurs && b instanceof EviterMurs) return false;
		else return true;
		}
	}
public static void afficher(MouvementMode a)
	{	
	if(a==null) System.out.println("null");	
	if(a instanceof Oscillatoire) System.out.println("Oscillatoire");	
	if(a instanceof Defensif) System.out.println("Defensif");		
	if(a instanceof EviterMurs) System.out.println("EviterMurs");	
	}

public Waypoint[] create_waypoints()	
	{
	double dis=100;	
	Waypoint[] collection=new Waypoint[6];
	double x=monRobot.getX();
	double y=monRobot.getY();
	double xmax=monRobot.getBattleFieldWidth();	
	double ymax=monRobot.getBattleFieldHeight();
	double heading=monRobot.getHeadingRadians();
	Devant devant=new Devant(new Point(x+dis*Math.sin(heading),y+dis*Math.cos(heading)),monRobot);
	Derriere derriere=new Derriere(new Point(x-dis*Math.sin(heading),y-dis*Math.cos(heading)),monRobot);

	DevantGauche devantGauche=new DevantGauche(new Point(x+dis*Math.sin(heading-p/4),y+dis*Math.cos(heading-p/4)),monRobot);
	DevantDroite devantDroite=new DevantDroite(new Point(x+dis*Math.sin(heading+p/4),y+dis*Math.cos(heading+p/4)),monRobot);
	
	DerriereGauche derriereGauche=new DerriereGauche(new Point(x-dis*Math.sin(heading+p/4),y-dis*Math.cos(heading+p/4)),monRobot);
	DerriereDroite derriereDroite=new DerriereDroite(new Point(x-dis*Math.sin(heading-p/4),y-dis*Math.cos(heading-p/4)),monRobot);	
	
	if(Point.is_not_in_area_forbiden(xmax,ymax,devant.position) && Point.is_not_in_zone(xmax,ymax,devant.position))
	{collection[0]=devant;}
		
	if(Point.is_not_in_area_forbiden(xmax,ymax,derriere.position) && Point.is_not_in_zone(xmax,ymax,derriere.position))
	{collection[1]=derriere;}			
	
	if(Point.is_not_in_area_forbiden(xmax,ymax,derriereGauche.position))
	{collection[2]=derriereGauche;}
	
	if(Point.is_not_in_area_forbiden(xmax,ymax,derriereDroite.position))
	{collection[3]=derriereDroite;}	
		
	if(Point.is_not_in_area_forbiden(xmax,ymax,devantGauche.position))
	{collection[4]=devantGauche;}
	
	if(Point.is_not_in_area_forbiden(xmax,ymax,devantDroite.position))
	{collection[5]=devantDroite;}
	
	return collection;		
	}
	
			
public Waypoint[] create_waypoints_sans_restrictions()	
	{
	double dis=100;	
	Waypoint[] collection=new Waypoint[6];
	double x=monRobot.getX();
	double y=monRobot.getY();
	double xmax=monRobot.getBattleFieldWidth();	
	double ymax=monRobot.getBattleFieldHeight();
	double heading=monRobot.getHeadingRadians();
	Devant devant=new Devant(new Point(x+dis*Math.sin(heading),y+dis*Math.cos(heading)),monRobot);
	Derriere derriere=new Derriere(new Point(x-dis*Math.sin(heading),y-dis*Math.cos(heading)),monRobot);

	DevantGauche devantGauche=new DevantGauche(new Point(x+dis*Math.sin(heading-p/4),y+dis*Math.cos(heading-p/4)),monRobot);
	DevantDroite devantDroite=new DevantDroite(new Point(x+dis*Math.sin(heading+p/4),y+dis*Math.cos(heading+p/4)),monRobot);
	
	DerriereGauche derriereGauche=new DerriereGauche(new Point(x-dis*Math.sin(heading+p/4),y-dis*Math.cos(heading+p/4)),monRobot);
	DerriereDroite derriereDroite=new DerriereDroite(new Point(x-dis*Math.sin(heading-p/4),y-dis*Math.cos(heading-p/4)),monRobot);	
	
	collection[0]=devant;	
	collection[1]=derriere;			
	collection[2]=derriereGauche;
	collection[3]=derriereDroite;
	collection[4]=devantGauche;
	collection[5]=devantDroite;
	
	return collection;		
	}	
	
			
public void moveTo(double angle)
	{
	double r=monRobot.getHeadingRadians()+p/2;
	if(r<angle)
		{
		if(angle-r<p) monRobot.setTurnRightRadians(angle-r);
		else monRobot.setTurnLeftRadians(2*p-angle+r);	
		}
	else
		{
		if(r-angle<p)	monRobot.setTurnLeftRadians(r-angle);
		else			monRobot.setTurnRightRadians(2*p-r+angle);
		}
	}	
			
public void changementAngle()
	{
	Point moi=new Point(monRobot.getX(),monRobot.getY());
	Point enn;
	if(informations.size()==1) enn=((Informations)informations.elementAt(0)).position;
	else enn=new Point(0,0);
	double angleEnn=Point.angle_absolu(moi,enn);
	moveTo(angleEnn);
	}	
						
}
			