/*
 * Wave.java
 *
 * Created on 15 maart 2004, 9:30
 */

package vic;
/**
 *
 * @author  Vic Stewart
 */
public class Wave
{
    double originX, originY;
    double BulletPower;
    double Radius;
    
    double enemyX, enemyY, enemyHeading;
    Situation situation;
    
    Situation getSituation()
    {
        return situation;
    }
    
    Wave(Situation pSituation, double power, double meX, double meY, double pEnemyX, double pEnemyY, double pEnemyHeading)
    {
        originX = meX;
        originY = meY;
        BulletPower = power;
        Radius = 0;
        update();
        enemyX = pEnemyX;
        enemyY = pEnemyY;
        enemyHeading = pEnemyHeading;
        situation = pSituation;
    }
    
    double getRadius()
    {
        return Radius;
    }
    
    void update()
    {
        Radius += (20 - 3 * BulletPower);
    }
    
    boolean hasReached(double enemyX, double enemyY)
    {
        return (Math.sqrt(Math.pow(originX-enemyX, 2) + Math.pow(originY-enemyY, 2)) - Radius) <= ((20D - 3D * BulletPower) / 2D);
    }
    
    double getEnemyX()
    {
        return enemyX;
    }
    double getEnemyY()
    {
        return enemyY;
    }
    double getEnemyHeading()
    {
        return enemyHeading;
    }
}