package kawigi.sbf;
import robocode.*;
import java.awt.geom.*;
/**
 * FloodNano - FloodMicro without the complex distance management.
 */
public class FloodNano extends AdvancedRobot
{
	static double currentDirection;
	static double currentEnergy;
	static double nextTime;
	
	public void run()
	{
		turnRadarRight(Double.POSITIVE_INFINITY);
	}

	public void onScannedRobot(ScannedRobotEvent e)
	{
		setTurnRadarLeft(getRadarTurnRemaining());
		double denergy = currentEnergy-(currentEnergy = e.getEnergy());
		if (nextTime-- <= 0 && denergy > 0 && denergy <= 3)
		{
			setMaxVelocity(2+Math.random()*20);
			currentDirection = (Math.random() < .5)?-40:40;
			nextTime = e.getDistance()/17;
		}
		setTurnRightRadians(Math.PI/2 + (denergy = e.getBearingRadians()));
		setTurnGunRightRadians(robocode.util.Utils.normalRelativeAngle(denergy+getHeadingRadians()-getGunHeadingRadians() + (Math.random()-.5)%.4));
		setFire(Math.min(currentEnergy, getEnergy())/4);
		if (!(new Rectangle2D.Double(18, 18, getBattleFieldWidth()-36, getBattleFieldHeight()-36)).contains(Math.sin(denergy = getHeadingRadians())*currentDirection + getX(),Math.cos(denergy)*currentDirection + getY()))
			currentDirection = -currentDirection;
		setAhead(currentDirection);
	}
}
