package djc;
import robocode.*;

/**
 * PatternAnalyser - a class by Simon Parker
 */
public class PatternAnalyser // implements java.io.Serializable
{
    //need the keep a record of the past samples
    int nextSampleIndex = 0;
    public Position[] sampleArray = new Position[FuturePositionArray.MAX_LOOKAHEAD_TIME];
    
    //each element of the array corresponds to a different velocity
    public FuturePositionArray futurePositionArray = new FuturePositionArray(this);
    
    //the most recent update time
    int latestUpdateTime = 0;
    Coordinate latestPosition = new Coordinate();
    //???	public double medianAverageDistance = 0;

    public PatternAnalyser() {
	sampleArray = new Position[FuturePositionArray.MAX_LOOKAHEAD_TIME];
	reset();
    }

    public void reset()
    {
	nextSampleIndex = 0;
	latestUpdateTime = 0;
	latestPosition = new Coordinate();
    }

    public void update(Coordinate currentPosition, double currentVelocity, double currentHeading_rad, int time)
    {
	double t0 = (double)latestUpdateTime;
	double t1 = (double)time;
	double x0 = latestPosition.x;
	double y0 = latestPosition.y;
	double x1 = currentPosition.x;
	double y1 = currentPosition.y;
	Coordinate interpolatedPosition = new Coordinate();
	for ( ; latestUpdateTime < time; latestUpdateTime++) {
	    interpolatedPosition.set
		( x0 + (x1 - x0) * ((double)latestUpdateTime - t0) / (t1 - t0),
		  y0 + (y1 - y0) * ((double)latestUpdateTime - t0) / (t1 - t0));

	    if (sampleArray[nextSampleIndex] == null) {
		sampleArray[nextSampleIndex] = new Position();
	    }

	    sampleArray[nextSampleIndex].set(interpolatedPosition, currentVelocity, currentHeading_rad);
	    nextSampleIndex++;
	    if (nextSampleIndex >= FuturePositionArray.MAX_LOOKAHEAD_TIME) nextSampleIndex = 0;

	    //??? something wrong here
	    futurePositionArray.update(interpolatedPosition, currentVelocity);
	}
	latestPosition.set(currentPosition);
    }

	
    protected Coordinate getEstimatedDeltaPosition(double velocity, double time)
    {
	//???medianAverageDistance = futurePositionArray.getMedianAverageDistance(velocity, time);
	return futurePositionArray.getPosition(velocity, time);
    }

    public Position getPosition(int timeBackFromLatest)
    {
	int index = (nextSampleIndex - 1 - timeBackFromLatest + FuturePositionArray.MAX_LOOKAHEAD_TIME)
	    % FuturePositionArray.MAX_LOOKAHEAD_TIME;
	
	return sampleArray[index];
    }
}
