package dam;

import robocode.*;
import java.util.*;

import dam.util.*;

public class MasterBot extends AdvancedRobot
{
	public static final double PI = Math.PI;
	protected Target target;
	/**
	 * allTargets contains all the targets that have so far been
	 * encountered during this match, unlike targets, which is
	 * cleared at the end of each round
	 */
	protected TargetList allTargets = new TargetList();
	protected TargetList targets = new TargetList();
	protected GridPoint hitPoint = new GridPoint(0,0,0);
	protected int hits = 0;
	
	public MasterBot(){
		target = new Target(this);
	}
	
	
	public TargetList getAllTargets(){ return allTargets; }
	public Target getTarget(){ return target; }
	public void setTarget(Target t){ target = t; }
	public TargetList getTargetList(){ return targets; }
	
	public double getDistance(double x, double y)
	{
		return BotMath.getRange(getX(), getY(), x, y);
	}
	
	public void onBulletHit(BulletHitEvent e)
	{
		if(e.getName().equals(target.getName())){
			target.addAccuracy(1.0);
			hits++;
		}
	}
	
	public void onBulletHitBullet(BulletHitBulletEvent e)
	{
		hits++;
	}
	
	public void onBulletMissed(BulletMissedEvent e)
	{
		target.addAccuracy(0.0);
		hits--;
	}
	
	//if a bearing is not within the -pi to pi range, alters it to provide the shortest angle
	public double normaliseBearing(double ang) 
	{
		if (ang > PI)
		ang -= 2*PI;
		if (ang < -PI)
		ang += 2*PI;
		return ang;
	}
	
	
	
	/**
	* Gets the bearing in degrees between the robot and some other point
	*/
	public double getBearingDegrees(double x, double y)
	{
		return Math.toDegrees(getBearingRadians(x, y));
	}
	
	public double getBearingRadians(double p, double v)
	{
		double val = BotMath.absbearing(getX(), getY(), p, v);
		return normaliseBearing(val - getHeadingRadians());
	}
	
	
	
	public void setClosestAsTarget()
	{
		double dist = 10000;
		double ndist;
		for(int i = 0; i < targets.size(); i++)
		{
			ndist = targets.get(i).getDistance();
			if(ndist < dist)
			{
				dist = ndist;
				target = targets.get(i);
			}
		}
	}
	
	public void onRobotDeath(RobotDeathEvent e) 
	{
		targets.remove(e.getName());
		if(e.getName().equals(target.getName()))
		{
			target = new Target(this);
		}
	}
	
	public void onHitByBullet(HitByBulletEvent e)
	{
		hitPoint = new GridPoint(getX(), getY(), -10);
	}
	
	/**
	* Get the last location where I was hit by a bullet
	*/
	public GridPoint getHitPoint(){ return hitPoint; }
	
	public void selectTarget(Target t)
	{
		if(target.equals(t)) return;
		else{
			target = t;
			hits = 0;
		}
	
	}
	
	
	/**
	 * Returns the hits.
	 * @return int
	 */
	public int getHits() {
		return hits;
	}

	/**
	 * Sets the hits.
	 * @param hits The hits to set
	 */
	public void setHits(int hits) {
		this.hits = hits;
	}
	
	/**
	* onScannedRobot: What to do when you see another robot. The default
	* behavior is to select the target for targetting if it is the closest one
	* available. This should be modified to select the closest one that is
	* a rival.
	*/
	public void onScannedRobot(ScannedRobotEvent e) {
		// we want to look for only close robots
		if(!targets.contains(e.getName())){
			if(!allTargets.contains(e.getName())){
				Target t = new Target(e, this);
				allTargets.add(t);
			}
			targets.add(allTargets.get(e.getName()));
		}
		Target t = targets.get(e.getName());
		t.update(e, this);
		if(t.getDistance() < target.getDistance()) {
	      selectTarget(t);
		}
	}
	
	

}