package kawigi.micro;
import robocode.*;
import java.util.*;
import java.awt.geom.*;
import java.awt.*;
/*
 * Shiz - micro melee bot by Kawigi, based on Coriantumr.  Shiz was the last one killed by Coriantumr, the second-to-last standing.
 *
 * Version 1.0 - first release.  Movement based on Coriantumr, somewhere a little after version 1.0 of Coriantumr.  Shoots
 * 		head-on.  I'd like to think it's on the same level as HawkOnFire, but I may just have to settle for the title of
 *		"second-to-last-standing", as is appropriate for the name I guess.
 *	*	*	*	*	*	*	*	*	*	*	*	*	*	*	*	*	*	*	*	*	*	*	*	*	*	*	*	*	*	*	*	*
 * Version 1.1 - Updated to something closer to Coriantumr 1.1/dev 1.2's movement and firepower and some other things.  Also
 *		now has basic team awareness!  No room for team communication, but enough room to make them not attack each other and
 *		appropriately react to each other.
 * This code uses code from Coriantumr, which is released under the terms of the KPL.
 */
public class Shiz extends TeamRobot
{
	static Point2D myLocation, last;
	static MicroEnemyInfo currentTarget;
	static Hashtable enemies;
	
	public void run()
	{
		setTurnRadarRight(Double.POSITIVE_INFINITY);
		setColors(Color.gray, null, Color.red);
		//meant to be reinitialized every round.  Wouldn't even be static except that they're smaller that way.
		enemies = new Hashtable();
		Point2D next = currentTarget = null;
		
		do
		{
			myLocation = new Point2D.Double(getX(), getY());
			if (currentTarget != null)
			{
				if (next == null)
					next = last = myLocation;
				boolean changed = false;
				double angle = 0, distance;
				//sometimes I'll change my point here, sometimes I won't.  It's a big mystery!
				do
				{
					Point2D p;
					if (new Rectangle2D.Double(30, 30, getBattleFieldWidth()-60, getBattleFieldHeight()-60).contains(p = projectPoint(myLocation, angle, Math.min((distance = myLocation.distance(currentTarget))/2, 300))) && findRisk(p) < findRisk(next))
					{
						changed = true;
						next = p;
					}
					angle += .1;
				}
				while (angle < Math.PI*2);
				//this helps the whole movement system know what direction I'm going, and avoid head-on targeting:
				if (changed)
					last = myLocation;
				if (getEnergy()/distance > .005)
					setFire(60*Math.min(currentTarget.energy, getEnergy())/distance);
				setTurnGunRightRadians(robocode.util.Utils.normalRelativeAngle(angle(currentTarget, myLocation)-getGunHeadingRadians()));
				double turn;
				if (Math.cos(turn = angle(next, myLocation)-getHeadingRadians()) < 0)
				{
					turn += Math.PI;
					distance = -distance;
				}
				setTurnRightRadians(robocode.util.Utils.normalRelativeAngle(turn));
				//other people have done this by setting the max velocity to 0 or 8.  This seems to be 7 bytes smaller:
				setAhead((Math.abs(getTurnRemainingRadians()) > 1) ? 0 : distance);
			}
			execute();
		}
		while (true);
	}
	
	private double findRisk(Point2D point)
	{
		double risk = 4/last.distanceSq(point) + .1/myLocation.distanceSq(point);
		// Using the old collections API is smaller than using the new one, because you can get a
		// value enumerator in one call, but you need two calls to get a value iterator on a Map.
		Enumeration enum1 = enemies.elements();
		do
		{
			MicroEnemyInfo e;
			//start with an anti-gravity-type value:
			double thisrisk = Math.max(getEnergy(), (e = (MicroEnemyInfo)enum1.nextElement()).energy)/point.distanceSq(e);
			//woah, nested iterations!  Here, I'm counting the enemies that are closer to e than the proposed point is.
			//The more, the better, since this robot would be less likely to target me.
			
			int closer = 0;
			Enumeration enum2 = enemies.elements();
			do
				//This might not be as accurate in teams, maybe I'll improve it later.
				if (.9*e.distance((MicroEnemyInfo)enum2.nextElement()) > e.distance(point))
					closer++;
			while (enum2.hasMoreElements());
			//try this, multiply this number by the number of enemies to which I would be the closest:
			//if they are likely targeting me, multiply by some factor that has to do with "perpendicularity"
			//(I think I remember David Alves calling it that):
			if (!e.isTeammate && (closer <= 1 || e.lastHit > getTime()-200 || e == currentTarget))
				//I had to think about this one, but I think DuelistMicroMelee helped me make sure that it was correct.  I can't remember anymore.
				thisrisk *= 1+Math.abs(Math.cos(angle(myLocation, point) - angle(e, myLocation)));
			risk += thisrisk;
		}
		while (enum1.hasMoreElements());
		return risk;
	}
	
	public void onScannedRobot(ScannedRobotEvent e)
	{
		String name;
		MicroEnemyInfo enemy = (MicroEnemyInfo)enemies.get(name = e.getName());
		if (enemy == null)
			enemies.put(name, enemy = new MicroEnemyInfo());
		//wasn't making my enemies Point2D objects a good idea?
		enemy.energy = e.getEnergy();
		enemy.setLocation(projectPoint(myLocation, getHeadingRadians()+e.getBearingRadians(), e.getDistance()));
		if (!(enemy.isTeammate = isTeammate(name)) && (currentTarget == null || targetability(enemy) < targetability(currentTarget)-100))
			currentTarget = enemy;
	}
	
	public static double targetability(MicroEnemyInfo e)
	{
		return myLocation.distance(e) - e.energy;
	}
	
	public void onHitByBullet(HitByBulletEvent e)
	{
		//what I won't do for 2 measley bytes:
		try
		{
			((MicroEnemyInfo)enemies.get(e.getName())).lastHit = getTime();
		}
		catch (NullPointerException ex)
		{
		}
	}
	
	public void onRobotDeath(RobotDeathEvent e)
	{
		//the EnemyInfo objects are volitile and made for a round at a time, so I can sacrifice them when they die:
		if (currentTarget == enemies.remove(e.getName()))
			currentTarget = null;
	}
	
	//utility functions, I figure anyone making a goto bot has something like these, and they
	//come in useful in a lot of other random places, too:
	private static Point2D projectPoint(Point2D startPoint, double theta, double dist)
	{
		return new Point2D.Double(startPoint.getX() + dist * Math.sin(theta), startPoint.getY() + dist * Math.cos(theta));
	}
	
	//This strange habit of putting point2 before point1 in this method - and the funny thing is I think
	//I've seen other people do the same thing:
	public static double angle(Point2D point2, Point2D point1)
	{
		return Math.atan2(point2.getX()-point1.getX(), point2.getY()-point1.getY());
	}
}
