package tzu.util;

/**
 * Constants used throughout tzu.
 */

public interface Constants {

    public static final boolean DEBUG = false;

    //******************************************************************
    //                                                                 *
    //                            BULLETS                              *
    //                                                                 *
    //******************************************************************

    public static final double  MAX_BULLET_SPEED        = 20;
    public static final double  MAX_BULLET_POWER        = 3.0;
    public static final double  MIN_BULLET_POWER        = 0.1;
    public static final double  ALMOST_MIN_BULLET_POWER = 0.11;
    public static final double  BULLET_HIT_REWARD       = 3.0;
    public static final double  HIT_DAMAGE              = 4.0;
    public static final double  ADDITIONAL_HIT_DAMAGE   = 2.0;
    public static final double  MAX_BULLET_DAMAGE       =
                                (HIT_DAMAGE * MAX_BULLET_POWER)
                              + (ADDITIONAL_HIT_DAMAGE
                              * (MAX_BULLET_POWER - 1));

    //******************************************************************
    //                                                                 *
    //                      SPEED AND MOVEMENT                         *
    //                                                                 *
    //******************************************************************

    public static final double  MAX_SPEED               = 8.0;
    public static final double  ALMOST_MAX_SPEED        = 7.9;
    public static final double  SLOW_SPEED              = 0.01;
    public static final double  ROBOT_ACCELERATION      = 1.0;
    public static final double  ROBOT_DEACCELERATION    = -2.0;
    public static final int     FORWARD                 = +1;
    public static final int     REVERSE                 = -1;

    //******************************************************************
    //                                                                 *
    //                           DISTANCE                              *
    //                                                                 *
    //******************************************************************

    public static final double  HEADED_FOR_WALL         = 70.0;
    public static final double  NEAR_WALL               = 50.0;
    public static final double  BUFFER_TARGET           = 410.0;
    public static final double  MIN_DISTANCE_TO_WALL    = 18.0;
    public static final double  NUDGE                   = 3.0;
    public static final double  HOP                     = 45.0;
    public static final double  SKIP                    = 100.0;
    public static final double  JUMP                    = 200.0;
    public static final double  LEAP                    = 400.0;

    //******************************************************************
    //                                                                 *
    //                         ANTI-GRAVITY                            *
    //                                                                 *
    //******************************************************************

    public static final double BUFFER_WALL                  = 50.0;
    public static final double BUFFER_BULLET                = 170.0;
    public static final double BUFFER_ROBOT                 = 300.0;
    public static final double BUFFER_CENTER                = 75.0;
    public static final double BUFFER_BEST_POSITION         = 80.0;

    public static final double ANTI_GRAVITY_WALLS           = 50.0;
    public static final double ANTI_GRAVITY_ROBOTS          = 1.0;
    public static final double ANTI_GRAVITY_CENTER          = 2.0;
    public static final double ANTI_GRAVITY_CORNERS         = 1.0;
    public static final double ANTI_GRAVITY_BULLETS         = 2.0;
    public static final double GRAVITY_BEST_POSITION        = .25;

    //******************************************************************
    //                                                                 *
    //                       TURNING AND ANGLES                        *
    //                                                                 *
    //******************************************************************

    public static final double  TURN_CONSTANT_1         = 10.0;
    public static final double  TURN_CONSTANT_2         = .75;
    public static final double  WIGGLE_ANGLE            = 40.0;
    public static final double  SHALLOW_ANGLE           = 45.0;

    //******************************************************************
    //                                                                 *
    //                            RADAR                                *
    //                                                                 *
    //******************************************************************

    public static final long    SHOOTING_ATTACK_MAX_AGE = 50;
    public static final long    RAMMING_ATTACK_MAX_AGE  = 20;
    public static final int     ATTACKER_MAX_SHOTS      = 1;
    public static final int     ATTACKER_MAX_RAM        = 4;
    public static final double  SCAN_ARC                = 45.0;
    public static final double  HALF_SCAN_ARC           = SCAN_ARC / 2;
    public static final long    MAX_SCAN_AGE            = 8;

    //******************************************************************
    //                                                                 *
    //                     GUN, TARGET, AIMING                         *
    //                                                                 *
    //******************************************************************

    public static final double  LEAD_EST_ITERATIONS     = 10.0;
    public static final double  TARGET_RICH_RATIO       = 1.0;
    public static final double  SHOOT_MAX_DISTANCE      = 1200.0;
    public static final double  SHOOT_MAX_GUN_TURN      = 7.0;

    //******************************************************************
    //                                                                 *
    //                         MISCELLANEOUS                           *
    //                                                                 *
    //******************************************************************


    public static final int     DATA_DIRECTORY_SIZE     = 200000;
    public static final int     NOT_IN_A_CORNER         = 0;
    public static final int     NORTHEAST_CORNER        = 1;
    public static final int     NORTHWEST_CORNER        = 2;
    public static final int     SOUTHEAST_CORNER        = 3;
    public static final int     SOUTHWEST_CORNER        = 4;

    public static final int     DROID                   = 0;
    public static final int     TEAMROBOT               = 1;
    public static final int     LEADER                  = 2;

    public static final double  A_0                     = 0.0;
    public static final double  A_45                    = 45.0;
    public static final double  A_90                    = 90.0;
    public static final double  A_180                   = 180.0;
    public static final double  A_270                   = 270.0;
    public static final double  A_360                   = 360.0;
}
