package vuen.cfCake;
import vuen.Cake;
import robocode.*;

public class cMovControl {
	private Cake oRobot = null;
	private cComControl oComControl = null;

	public cMovAntiGrav mMovAntiGrav = null;
	public cMovWall mMovWall = null;
	public cMovDodge mMovDodge = null;
	public cMovLine mMovLine = null;

	public String mPattern = "Off";
	
	public cMovControl(Cake pRobot, cComControl pComControl) {
		oRobot = pRobot;
		oComControl = pComControl;
		
		mMovAntiGrav = new cMovAntiGrav(oRobot, this, oComControl);
		mMovWall = new cMovWall(oRobot, this, oComControl);
		mMovLine = new cMovLine(oRobot, this, oComControl);
		mMovDodge = new cMovDodge(oRobot, this, oComControl);
		
		doNew("Optimal");
	}
	
	public void doPrintStats() {
		//oRobot.out.println("MOV: Dodge Learning - Individual Data");
		//for (int i = 0; i < oComControl.mTotalNames; i++) {
		//	oRobot.out.println("    " + oComControl.mEnemyNames[i]);
		//	oRobot.out.println("       Optimal Distance(Inc): " + Math.round((double)mMovDodge.mAngleDistance[i] * (double)1000) / (double)1000 + "(" + Math.round((double)mMovDodge.mDistanceChange[i] * (double)1000) / (double)1000 + ")");
		//}
	}
	
	public void doPrintEnemyStats(int i) {
		oRobot.out.print("     MOV: Dodge: Optimal Distance(Inc): " + Math.round((double)mMovDodge.mAngleDistance[i] * (double)1000) / (double)1000 + "(" + Math.round((double)Math.abs(mMovDodge.mDistanceChange[i]) * (double)1000) / (double)1000 + ")");
		if (mMovDodge.mStatMode[i]) oRobot.out.println("*"); else oRobot.out.println("");
		oRobot.out.print("                 Optimal Jiggle(Inc): " + Math.round((double)1000 / (double)mMovDodge.mJiggleMult[i]) / (double)1000 + "(" + Math.round((double)Math.max(mMovDodge.mJiggleInc[i], 1 / Math.abs(mMovDodge.mJiggleInc[i])) * (double)1000) / (double)1000 + ")");
		if (mMovDodge.mStatMode[i] == false) oRobot.out.println("*"); else oRobot.out.println("");
	}
	
	public void doTurn() {
		doNew("Optimal");
		if (mPattern == "Line") {
			mMovLine.doTurn();
		} else if (mPattern == "Dodge") {
			mMovDodge.doTurn();
		}
	}
	
	public void doNew(String pPattern) {
		String pNPattern = null;
		if (pPattern == "Optimum" || pPattern == "Optimal") {
			if (oRobot.getOthers() == 1) {
				pNPattern = "Dodge";
				//pNPattern = "Line";
			} else {
				pNPattern = "Line";
			}
		} else pNPattern = pPattern;
		if (mPattern == pNPattern) return;
		if (mPattern == "Line") {
			mMovLine.doUnInit();
		} else if (mPattern == "Dodge") {
			mMovDodge.doUnInit();
		} else if (pPattern == "Off") {
		}
		if (pNPattern == "Line") {
			mPattern = "Line";
			if (oRobot.getTime() == 0)
				oRobot.out.println(", MOV: " + mPattern);
			else
				oRobot.out.println("[" + oRobot.getTime() + "] MOV: Changing Movement Pattern to " + mPattern);
			mMovLine.doInit();
		} else if (pNPattern == "Dodge") {
			mPattern = "Dodge";
			if (oRobot.getTime() == 0)
				oRobot.out.println(", MOV: " + mPattern);
			else
				oRobot.out.println("[" + oRobot.getTime() + "] MOV: Changing Movement Pattern to " + mPattern);
			mMovDodge.doInit();
		} else if (pNPattern == "Off") {
			//oRobot.out.println("[" + oRobot.getTime() + "] MOV: Turning off Movement");
			mPattern = "Off";
			oRobot.setAhead(0);
			oRobot.setTurnRight(0);
		}
	}
	
	public void onWin(WinEvent e) {
		doNew("Off");
	}
		
	public void doBLUpdate(double pEnergy) {
		if (mPattern == "Dodge") mMovDodge.doBLUpdate(pEnergy);
	}
	
	public void doBLNextReset() {
		if (mPattern == "Dodge") mMovDodge.mNextReset = true;
	}
	
	public void onHitRobot(HitRobotEvent e) {
		if (mPattern == "Dodge") mMovDodge.onHitRobot(e);
		else if (mPattern == "Line") mMovLine.onHitRobot(e);
	}
	
	public void onHitWall(HitWallEvent e) {
		if (mPattern == "Dodge") mMovDodge.onHitWall(e);
		else if (mPattern == "Line") mMovLine.onHitWall(e);
	}
	
	public void onHitByBullet(HitByBulletEvent e) {
		if (mPattern == "Dodge") mMovDodge.onHitByBullet(e);
		else if (mPattern == "Line") mMovLine.onHitByBullet(e);
	}
	
	public void onBulletHit(BulletHitEvent e) {
		if (mPattern == "Dodge") mMovDodge.onBulletHit(e);
		else if (mPattern == "Line") mMovLine.onBulletHit(e);
	}
}