package Ex;
import robocode.*;
import java.awt.Color;
import java.awt.Graphics;

public class Survival extends AdvancedRobot
{
	
	double bulletPower = 3;
	static double moveDirection = 1;
	double previousEnergy = 100;
	
	int scannedX = Integer.MIN_VALUE;
	int scannedY = Integer.MIN_VALUE;
	
	double i = 0; 
	double u = 0;
	double waveCount;
	double uWaveCount;
	double hitCount;
	
	int bulletScannedX = Integer.MIN_VALUE;
	int bulletScannedY = Integer.MIN_VALUE;
	
	int gunScannedX = Integer.MIN_VALUE;
	int gunScannedY = Integer.MIN_VALUE;
	
	int bearingX = Integer.MIN_VALUE;
	int bearingY = Integer.MIN_VALUE;	
	
	public void run() {
		
		setAdjustRadarForGunTurn(true);
		setAdjustGunForRobotTurn(true);

		setBodyColor(new Color(161,11,11));
		setGunColor(new Color(178,191,10));
		setRadarColor(new Color(171,161,149));
		setBulletColor(new Color(171,171,134));
		setScanColor(new Color(213,156,165));
		
		while(true) {
			turnRadarRightRadians(Double.POSITIVE_INFINITY);
		}
	}

	public void onScannedRobot(ScannedRobotEvent e) {
		
		double angle = Math.toRadians((getHeading() + e.getBearing()) % 360);
		iWavePaint(e);
		uWavePaint(e);
		double absoluteBearing=e.getBearingRadians() + getHeadingRadians();
		double latVel= e.getVelocity()  * Math.sin(e.getHeadingRadians() - absoluteBearing);
		double gunTurnAmt;
		paint(e);
		if (e.getEnergy() < 2 && getEnergy() > e.getEnergy()) {
				bulletPower = 0;
			}		
		if (e.getVelocity() == 0 && e.getDistance() < 100) {
			setTurnRadarRightRadians(1.9 * robocode.util.Utils.normalRelativeAngle(absoluteBearing - getRadarHeadingRadians()));
			setTurnRight(e.getBearing() - 90);
			setAhead(90 * moveDirection);
		}else if (e.getVelocity() == 0) {
			setTurnRadarRightRadians(1.9 * robocode.util.Utils.normalRelativeAngle(absoluteBearing - getRadarHeadingRadians()));
			//bulletPower = 3;
			setTurnRight(e.getBearing() - 90);
			setAhead(90 * moveDirection);
			setBack(90 * moveDirection);
		} else {	
			if (e.getDistance() < 100) {
				bulletPower = 3;
				setTurnRightRadians(robocode.util.Utils.normalRelativeAngle(absoluteBearing-getHeadingRadians()+latVel/getVelocity()));
				setTurnRight(e.getBearing() - 90);
				setBack(30);
				bulletPower = 2;
			}
			if (e.getDistance() < 200 && e.getDistance() > 100) {
				setTurnRightRadians(robocode.util.Utils.normalRelativeAngle(absoluteBearing-getHeadingRadians()+latVel/getVelocity()));
				setAhead(20);
			}	
			if (e.getDistance() <300 && e.getDistance() > 200) {
				setTurnRight(e.getBearing() - 90);
			}
			if (e.getDistance() > 300 && e.getDistance() < 400) 
				setTurnRight(e.getBearing() - 90);
				setAhead(20 * moveDirection);
			}
		
			if (e.getDistance() > 400) {
				gunTurnAmt = robocode.util.Utils.normalRelativeAngle(absoluteBearing- getGunHeadingRadians()+latVel/22);
				//setTurnGunRightRadians(gunTurnAmt); 
				setTurnRightRadians(robocode.util.Utils.normalRelativeAngle(absoluteBearing-getHeadingRadians()+latVel/getVelocity()));
				setAhead(300 * moveDirection);
			}
		
			/*
			PREDICTIVE GUN
				
			if (e.getDistance() > 400) {
				gunTurnAmt = robocode.util.Utils.normalRelativeAngle(absoluteBearing- getGunHeadingRadians()+latVel/22);
				setTurnGunRightRadians(gunTurnAmt); 
			} else {
			gunTurnAmt = robocode.util.Utils.normalRelativeAngle(absoluteBearing- getGunHeadingRadians()+latVel/15);
			setTurnGunRightRadians(gunTurnAmt); 
			}
			*/
			setTurnRadarRightRadians(1.9 * robocode.util.Utils.normalRelativeAngle(absoluteBearing - getRadarHeadingRadians()) * 1.5);
			gunTurnAmt = robocode.util.Utils.normalRelativeAngle(absoluteBearing- getGunHeadingRadians()+latVel/22);
			setTurnGunRightRadians(gunTurnAmt); 
			fire(bulletPower);
			
		scannedX = (int)(getX() + Math.sin(angle) * e.getDistance());
     	scannedY = (int)(getY() + Math.cos(angle) * e.getDistance());

		gunScannedX = (int)(getX() + Math.sin(angle));
     	gunScannedY = (int)(getY() + Math.cos(angle));

		bulletScannedX = (int)(getX() + Math.sin(angle) * e.getDistance());
     	bulletScannedY = (int)(getY() + Math.cos(angle) * e.getDistance());
		bearingX = (int)(getX() + Math.sin(angle));
		bearingY = (int)(getY() + Math.sin(angle));
		paint(e);
		
	}
	public void paint(ScannedRobotEvent e) {
    
		Graphics g = getGraphics();
		g.setColor(Color.black);  
		
    	g.drawLine(scannedX, scannedY,(int)getX(), (int)getY());
		if (e.getDistance() > 500) {
		g.setColor(Color.black);
		g.drawLine(bulletScannedX - 10, bulletScannedY - 10, (int)getX(), (int)getY());
		g.drawLine(bulletScannedX - 15, bulletScannedY - 15, (int)getX(), (int)getY());
		g.drawLine(bulletScannedX - 20, bulletScannedY - 20, (int)getX(), (int)getY());
		
		g.drawLine(bulletScannedX + 10, bulletScannedY + 10, (int)getX(), (int)getY());
		g.drawLine(bulletScannedX + 15, bulletScannedY + 15, (int)getX(), (int)getY());
		g.drawLine(bulletScannedX + 20, bulletScannedY + 20, (int)getX(), (int)getY());
		}
		
		if (e.getDistance() < 200) {
			g.setColor(Color.yellow);
		} else {
		g.setColor(Color.red);
		}
 		g.drawLine(bulletScannedX - 30, bulletScannedY - 30, (int)getX(), (int)getY());
		g.drawLine(bulletScannedX - 40, bulletScannedY - 40, (int)getX(), (int)getY());
		g.drawLine(bulletScannedX - 50, bulletScannedY - 50, (int)getX(), (int)getY());
		g.drawLine(bulletScannedX - 60, bulletScannedY - 60, (int)getX(), (int)getY());
		g.drawLine(bulletScannedX - 70, bulletScannedY - 70, (int)getX(), (int)getY());
		g.drawLine(bulletScannedX - 80, bulletScannedY - 80, (int)getX(), (int)getY());
		
		g.drawLine(bulletScannedX + 30, bulletScannedY + 30, (int)getX(), (int)getY());
		g.drawLine(bulletScannedX + 40, bulletScannedY + 40, (int)getX(), (int)getY());
		g.drawLine(bulletScannedX + 50, bulletScannedY + 50, (int)getX(), (int)getY());
		g.drawLine(bulletScannedX + 60, bulletScannedY + 60, (int)getX(), (int)getY());
		g.drawLine(bulletScannedX + 70, bulletScannedY + 70, (int)getX(), (int)getY());
		g.drawLine(bulletScannedX + 80, bulletScannedY + 80, (int)getX(), (int)getY());
		
		
	}	

	public void iWavePaint(ScannedRobotEvent e) {
		Graphics g = getGraphics();
		//double absoluteBearing=e.getBearingRadians() + getHeadingRadians();	
	//	double latVel= e.getVelocity()  * Math.sin(e.getHeadingRadians() - absoluteBearing);
	//	double enemyX = getX() + e.getDistance() * Math.sin(absoluteBearing);
	//	double enemyY = getY() + e.getDistance() * Math.cos(absoluteBearing);
	//	double predictedX = enemyX, predictedY = enemyY;
		
					
		if (e.getDistance() < 200) {
			g.setColor(Color.red);
		}
		if (e.getDistance() < 400 && e.getDistance() > 200) {
			g.setColor(Color.blue);
		}
		if (e.getDistance() > 400) {
			g.setColor(Color.green);
		}
		
		g.drawOval(scannedX -  (int)i , scannedY -  (int)i , (int)i *2,(int)i *2);
		g.setColor(Color.white);
		g.drawLine(scannedX -  (int)i , scannedY -  (int)i , (int)getX(), (int)getY());
		
		i++;
		i++;
		i++;
		i++;
		i++;
		i++;
		i++;
		i++;
		i++;
		i++;
		i++;
		i++;
		i++;
		i++;
		i++;
		i++;
	
		if (i >= e.getDistance() - 20) {
			out.println(i);
		}
		if (i >= e.getDistance()) {
		i = 0;
		out.println("avoid!");
		waveCount++;
		if (waveCount++ > 3) {
			waveCount = 0;
			moveDirection = -moveDirection;
			setTurnRight(e.getBearing() - 90);
		}
		
		setAhead(45 * moveDirection);
		
		}
	}
	public void uWavePaint(ScannedRobotEvent e) {
		Graphics g = getGraphics();
		
		g.setColor(Color.white);
		
		g.drawOval(gunScannedX -  (int)u , gunScannedY -  (int)u , (int)u *2,(int)u *2);
			  
		u++;
		u++;
		u++;
		u++;
		u++;
		u++;
		u++;
		u++;
		u++;
		u++;
		u++;
		u++;
			
		if (u >= e.getDistance()) {
		u = 0;
		}
	}
	public void onHitRobot(HitRobotEvent e) {
		i = 0;
		u = 0;
	}		
	public void onBulletMissed(BulletMissedEvent e) {
		bulletPower = 2;
		moveDirection = -moveDirection;
		
	}
	public void onHitByBullet(HitByBulletEvent e) {
		hitCount++;
		if (hitCount > 3) {
			moveDirection = -moveDirection;
			hitCount = 0;
		}
	}
	public void onBulletHit(BulletHitEvent e) {
		bulletPower = 3;
	}
	public void onHitWall(HitWallEvent e) {
		moveDirection = -moveDirection;
		setAhead(30 * moveDirection);
		setTurnRight(e.getBearing() - 90);
	}	
	public void onWin(WinEvent e) {
		Graphics g = getGraphics();
		g.setColor(Color.white);
		g.fillRect(300,300,50,50);
		g.fillRect(500,500,50,50);
		
		g.setColor(Color.blue);
		g.fillRect(200,3,23,30);
		g.setColor(Color.red);
		g.fillRect(600,570,34,50);
		
		g.setColor(Color.green);
		g.fillRect(600,200,10,50);
		g.setColor(Color.cyan);
		g.fillRect(700,700,30,57);
		
		g.setColor(Color.yellow);
		g.fillRect(100,300,3,50);
		g.setColor(Color.black);
		g.fillRect(500,50,50,50);
		
		setAhead(50);
	}
}
