package kawigi.spare.util;

/**
 * OffensiveVirtualBullet - meant to assist with constructing Sandbox-sytle pattern aiming
 */
public class OffensiveVirtualBullet
{
	private String name;
	private double startx, starty, startgunheading, requiredgunheading;
	private long firetime;
	private boolean hit;
	
	public OffensiveVirtualBullet(String name, double heading, double startx, double starty, long firetime)
	{
		this.name = name;
		requiredgunheading = startgunheading = heading;
		this.startx = startx;
		this.starty = starty;
		this.firetime = firetime;
		hit = false;
	}
	
	public boolean alreadyHit()
	{
		return hit;
	}
	
	public String getName()
	{
		return name;
	}
	
	public void updateEnemy(double x, double y, long time)
	{
		if (!hit)
		{
			double distance = Math.sqrt((x-startx)*(x-startx)+(y-starty)*(y-starty));
			requiredgunheading = Math.atan2(x-startx, y-starty);
			if (distance <= 11*(time-firetime))		//could have hit now.
				hit = true;
		}
	}
	
	public double getGunTurn()
	{
		double ret = requiredgunheading-startgunheading;
		ret = ((ret-Math.PI)%(Math.PI*2)+Math.PI*2)%(Math.PI*2)-Math.PI;
		return ret;
	}
}
