package dft.inject.move;
import dft.inject.util.Position;
import dft.inject.util.Utils;
import robocode.*;
import java.awt.*;
import java.awt.geom.*;
import java.util.*;
import java.util.zip.*;

public class Surf {	
	
	// These are the only variables being accessed by the main class
	private double finalAhead = 0;
	private double finalTurn = 0;
	private double finalMaxVelocity = 8;
	
	public double getAhead() {
		return finalAhead;
	}		
	public double getTurn() {
		return finalTurn;
	}	
	public double getMaxVelocity() {
		return finalMaxVelocity;
	}
	
	// How many factors are we currently using?	
	private static final double MIDDLE_FACTOR = 12;
	private static final int TOTAL_FACTORS = 25;
	// The arrays of stats
	ArrayList enemyWaves = new ArrayList();
	ArrayList enemyBullets = new ArrayList();
	private static double[] recentHits = new double[TOTAL_FACTORS];
	private static double[] allHits = new double[TOTAL_FACTORS];
	private static double[][][][] segmentHits = new double[3][5][7][TOTAL_FACTORS];
	private static double[][][][] allSegmentHits = new double[3][5][7][TOTAL_FACTORS];
	private static double[] recentVisits = new double[TOTAL_FACTORS];
	private static double[][][] patternHits = new double[9][9][TOTAL_FACTORS];
	// Enemy data to be saved from turn to turn
	private double enemyEnergy = 100;
	private double enemyDistance;
	private Point2D enemyLocation = new Point2D.Double(0,0);
	private Point2D realEnemyLocation = new Point2D.Double(0,0);	
	private static Rectangle2D battleField;
	private double lastBulletPower = 1.9;
	// Data about myself to be saved
	private Point2D myLocation = new Point2D.Double(0,0);
	private double myDirection = 1;
	private double myLatVelocity = 0;
	private double myVelocity = 0;
	private double orbitDirection = 1;
	private double targetAngle = Math.PI/2+Math.PI/10;
	// Variables for segmenting
	private static boolean firstTime = true;	
	private int accelIndex, distanceIndex, velocityIndex, longPatternIndex, shortPatternIndex;
	private double[] pattern = new double[10];
	private static double[] dullVector = new double[TOTAL_FACTORS];
					
	public void onScannedRobot(AdvancedRobot a, ScannedRobotEvent e) {
		// The first time the bot runs, populate the flattener
		if (firstTime) {
			battleField = new Rectangle2D.Double(18, 18, a.getBattleFieldWidth()-36, a.getBattleFieldHeight()-36);	
			firstTime = false;
			recentHits[(int)MIDDLE_FACTOR]=1;			
			for (int i = 0; i < TOTAL_FACTORS; i++) {
				dullVector[i] = 1;
				recentVisits[i] = 1/(double)TOTAL_FACTORS;
			}
		}
		// Always need this		
		double absBearing = e.getBearingRadians() + a.getHeadingRadians();
	/*	The flattener is currently not working, so none of this is needed
		
		// Information about a particular wave			
		EnemyWave w;
		enemyWaves.add(w = new EnemyWave());
		// How fast is bullet travelling
		w.velocity = 20 - 3 * lastBulletPower;
		// What is the angle from enemy to me
		w.angle = Utils.absoluteBearing(realEnemyLocation,myLocation);
		// How far can we move
		w.escape = Math.asin(9/w.velocity)*myDirection;	
		// Bullet's origin
		w.start = Utils.project(realEnemyLocation,w.angle,w.velocity);					
		w.current = Utils.project(realEnemyLocation,w.angle,w.velocity);
		// Time of bullet's launch
		w.startTime = a.getTime()-1;	
				
	*/	
						
		// Enemy has fired; add this information to the surfable ArrayList
		if ((enemyEnergy -= e.getEnergy()) <= 3.0 && enemyEnergy > 0) {
			lastBulletPower = enemyEnergy;
			EnemyWave wb;
			enemyBullets.add(wb = new EnemyWave());
			wb.velocity = 20 - 3 * enemyEnergy;
			wb.angle = Utils.absoluteBearing(realEnemyLocation,myLocation);
			wb.escape = Math.asin(9/wb.velocity)*myDirection;	
			wb.start = Utils.project(realEnemyLocation,wb.angle,wb.velocity);			
			wb.current = Utils.project(realEnemyLocation,wb.angle,wb.velocity);
			wb.startTime = a.getTime()-1;	
			// Preparing buckets for update
			wb.recentSegment = segmentHits[accelIndex][velocityIndex][distanceIndex];
			wb.allSegment = allSegmentHits[accelIndex][velocityIndex][distanceIndex];
			wb.patternHits = patternHits[longPatternIndex][shortPatternIndex];			
		}
		
		// Data to be used next tick (and now, I suppose)
		enemyEnergy = e.getEnergy();	
		enemyDistance = e.getDistance();
		myLocation = new Point2D.Double(a.getX(), a.getY());
		realEnemyLocation = Utils.project(myLocation,absBearing,enemyDistance);		
		myLatVelocity = Math.sin(a.getHeadingRadians()-Utils.absoluteBearing(realEnemyLocation,myLocation))*a.getVelocity();							
		myDirection = (myLatVelocity < 0)?-1:1;	 
		
		// Movement segments
		accelIndex = (int)(Math.abs(a.getVelocity()) - Math.abs(myVelocity));
		if (accelIndex != 0) 
			accelIndex = accelIndex > 0 ? 2 : 1;
		distanceIndex = (int)Math.max(5,(e.getDistance()/200)+1);
		velocityIndex = (int)Math.abs(a.getVelocity()/2);
		// This is a more complicated segment, the pattern segment
		// It takes my average lateral velocity over the last 10 and the last 3 ticks
		for (int i = 0; i < 9; i++) {
			pattern[i] = pattern[i+1];
			longPatternIndex += pattern[i];
			if (i >= 7)
				shortPatternIndex += pattern[i];
		}
		pattern[9] = (int)myLatVelocity;
		longPatternIndex += pattern[9];
		shortPatternIndex += pattern[9];
		longPatternIndex = (int)Math.min(8,Math.abs(Math.round(longPatternIndex/10)));
		shortPatternIndex = (int)Math.min(8,Math.abs(Math.round(shortPatternIndex/3)));
		// Yeah...
		myVelocity = a.getVelocity();
		enemyLocation = realEnemyLocation;
		
		// Let's get ready to rumble...
		// These simple vars will tell which direction to move
		double f = 0;
		double r = 0;
		double s = 0;
		// Used for future prediction
		Position forward, reverse;
		forward = new Position(myLocation,a.getHeadingRadians(),a.getVelocity());
		reverse = new Position(myLocation,a.getHeadingRadians(),a.getVelocity());
		// What is the best angle to move at?
		if (e.getDistance() < 120) {
			targetAngle = Math.PI/2 + Math.PI/2.5;
		}
		if (e.getDistance() < 200) {
			targetAngle = Math.PI/2 + Math.PI/3.5;
		}
		else if (e.getDistance() < 400) {
			targetAngle = Math.PI/2 + Math.PI/9;
		}
		else {
			targetAngle = Math.PI/2 + Math.PI/12;
		}
	/* This was for the broken flattener
	
		// Checks on and updates the individual waves, not the actual bullets
		for (int i = 0; i < enemyWaves.size(); i++) {
			EnemyWave b = (EnemyWave)enemyWaves.get(i);
			b.current = Utils.project(b.start,b.angle,b.velocity*(a.getTime()-b.startTime));			
			double currentDistance = Utils.findDistance(b.current,b.start);			
		// If the wave has hit, delete it, but also update the recentVisits (the flattener)			
		if (Utils.findDistance(b.start,myLocation) < currentDistance) {
			
			double currentGF = Utils.findGF(b.angle,Utils.absoluteBearing(b.start,myLocation),b.escape,MIDDLE_FACTOR);	
			// Roll it...
			for (int k = 0; k < TOTAL_FACTORS; k++) {
				recentVisits[i] *= 0.90;
			}		
			recentVisits[(int)currentGF]+=0.08;
			recentVisits[(int)currentGF-1]+=0.01;
			recentVisits[(int)currentGF+1]+=0.01;
			enemyWaves.remove(i);	
		}		
		}
	*/
		
		// Now work with the actual bullets
		for (int i = 0; i < enemyBullets.size(); i++) {			
			// Move them
			EnemyWave b = (EnemyWave)enemyBullets.get(i);
			b.current = Utils.project(b.start,b.angle,b.velocity*(a.getTime()-b.startTime));			
			double currentDistance = Utils.findDistance(b.current,b.start);			
			double currentGF = Utils.findGF(b.angle,Utils.absoluteBearing(b.start,myLocation),b.escape,MIDDLE_FACTOR);						
			double currentAng = Utils.findAngle(b.angle,b.escape,currentGF,MIDDLE_FACTOR);	
			Point2D currentGFLocation = Utils.project(b.start,currentAng,currentDistance);
			double distanceToMe = Utils.findDistance(currentGFLocation,myLocation);			
				
		// Has the wave has hit?			
		if (Utils.findDistance(b.start,myLocation) < currentDistance-40) {
			enemyBullets.remove(i);	
		}		
		// If not, surf it
		else if (Utils.findDistance(b.start,myLocation) > currentDistance+20) {		
			// Predict the point at which the wave will impact
			// The distances tell how far ahead we should predict
			double waveDistance = Utils.findDistance(b.start,b.current)-b.velocity;
			double fDistance = Utils.findDistance(forward.getLocation(),b.start);
			double rDistance = Utils.findDistance(reverse.getLocation(),b.start);				
			while ((waveDistance += b.velocity) < fDistance || waveDistance < rDistance) {
				// If we go forward full speed
				if (waveDistance < fDistance) {
					forward = forward.predict(enemyLocation,8,targetAngle,orbitDirection,battleField);
					fDistance = Utils.findDistance(forward.getLocation(),b.start);
				}
				// If we reverse to full speed
				if (waveDistance < rDistance) {
					reverse = reverse.predict(enemyLocation,8,targetAngle,-orbitDirection,battleField);
					rDistance = Utils.findDistance(reverse.getLocation(),b.start);
				}				
			}
			// What guess factors will we end up at?
			int forwardGF = (int)Utils.findGF(b.angle,Utils.absoluteBearing(b.start,forward.getLocation()),b.escape,MIDDLE_FACTOR);
			int reverseGF = (int)Utils.findGF(b.angle,Utils.absoluteBearing(b.start,reverse.getLocation()),b.escape,MIDDLE_FACTOR);
			int stoppedGF = (int)Utils.findGF(b.angle,Utils.absoluteBearing(b.start,Utils.project(myLocation,a.getHeadingRadians(),b.velocity)),b.escape,MIDDLE_FACTOR);
			
			double[] totalCurrent = new double[TOTAL_FACTORS];
			// Coeffiecients for the stats arrays
			double pH = 1.0;
			double rH = 1.0;
			double rS = 1.0;
			// Combine the segments so that we only have to smooth them once
			for (int j = 0; j < TOTAL_FACTORS; j++) {
				totalCurrent[j] += pH*b.patternHits[j] + rH*recentHits[j] + rS*b.recentSegment[j];
			}
			// Add the danger values divided by the square root of the distance
			f += Utils.smoothed(forwardGF,totalCurrent,TOTAL_FACTORS)/Math.pow(distanceToMe,0.5);///Utils.smoothed(forwardGF,dullVector,TOTAL_FACTORS);
			r += Utils.smoothed(reverseGF,totalCurrent,TOTAL_FACTORS)/Math.pow(distanceToMe,0.5);///Utils.smoothed(reverseGF,dullVector,TOTAL_FACTORS);
			s += Utils.smoothed(stoppedGF,totalCurrent,TOTAL_FACTORS)/Math.pow(distanceToMe,0.5);///Utils.smoothed(stoppedGF,dullVector,TOTAL_FACTORS);
		}		
		}
		
		// Working dive protection:
		forward = new Position(myLocation,a.getHeadingRadians(),a.getVelocity());
		int j = 0;		
		// Where will be in 10 ticks?
		while (j < 10) {
			forward = forward.predict(enemyLocation,8,targetAngle,orbitDirection,battleField);
			j++;
		}
		double fDistance = Utils.findDistance(forward.getLocation(),enemyLocation);
		// If we will be too close, consider reversing or stopping
		if (fDistance < 240 && 90-Math.abs(90-Math.abs(e.getBearing())) < 60) {
			r *= 0.9;
			s *= 0.9;
		}
			
		// If there are no bullets in the air
		if (enemyBullets.size() == 0) {		
			// Can we get farther away by reversing?	
			reverse = new Position(myLocation,a.getHeadingRadians(),a.getVelocity());
			j = 0;			
			while (j < 10) {
				reverse = reverse.predict(enemyLocation,8,targetAngle,-orbitDirection,battleField);
				j++;
			}
			double rDistance = Utils.findDistance(reverse.getLocation(),enemyLocation);	
			double sDistance = Utils.findDistance(myLocation,enemyLocation);
		 	if (fDistance < rDistance) { 
				targetAngle = Math.PI/2+Math.PI/6;
				f = 2;
				s = 1;
			}
			// Stop if we've reached that maximum distance (never actually does this right, but does it well enough)
			else if (sDistance > rDistance && sDistance > fDistance) {
				f = 1;
				r = 2;
			}
		}
		
		// Should we invert or stay still?
		finalMaxVelocity = 8;
		if (r < f && r < s) orbitDirection = -orbitDirection;	
		else if (s < f) finalMaxVelocity = 0;
		
							
	// The actual movement checks to make sure the angle is in the battle field
	Point2D destination;	
	double angle = targetAngle;
	while (!battleField.contains(destination = Utils.project(myLocation, absBearing + orbitDirection*(angle-=0.08), 120)) && angle > -targetAngle);
	finalTurn = Utils.absoluteBearing(myLocation, destination) - a.getHeadingRadians();
	if (angle < 0) finalMaxVelocity = 0;
	finalAhead = Math.cos(finalTurn)*100;
	finalTurn = Math.tan(finalTurn);	
	// Be sure not to hit the wall
	if (!battleField.contains(Utils.project(myLocation, a.getHeadingRadians(), a.getVelocity()*3.25))) finalAhead = 0;
	if (!battleField.contains(Utils.project(myLocation, a.getHeadingRadians(), a.getVelocity()*5))) finalAhead = 4;
	}
	
	// Uh oh! We've been hit
	public void onHitByBullet(AdvancedRobot a, HitByBulletEvent e) {
		
		
		System.out.print("HIT at GF ");
		for (int i = 0; i < enemyBullets.size(); i++) {
			Point2D theBullet = new Point2D.Double(e.getBullet().getX(),e.getBullet().getY());
			EnemyWave b = (EnemyWave)enemyBullets.get(i);
			double currentDistance = Utils.findDistance(b.current,b.start);			
			int currentGF = (int)Utils.findGF(b.angle,e.getBullet().getHeadingRadians(),b.escape,MIDDLE_FACTOR);
			double myDistance = Utils.findDistance(theBullet,b.start);		
			// Update with the correct bullet	
			if (Math.abs(myDistance-currentDistance) < 40) {			
				updateStats(currentGF,i,false);
				System.out.print(", BP " + e.getPower() + ", DIST " + enemyDistance);
			}
		
		}
		System.out.println();
	}
	// Make sure we know the enemy's energy so we don't miss a bullet that's in the air
	public void onBulletHit(AdvancedRobot a, BulletHitEvent e) {
		Bullet b = e.getBullet();
        double power = b.getPower();
        enemyEnergy -= 4*power + Math.max(2*power - 1, 0);
	}
	public void onBulletHitBullet(AdvancedRobot a, BulletHitBulletEvent e) {
		// If my bullet hits your bullet
		System.out.print("BHB at GF ");
		for (int i = 0; i < enemyBullets.size(); i++) {
			Point2D theBullet = new Point2D.Double(e.getHitBullet().getX(),e.getHitBullet().getY());
			EnemyWave b = (EnemyWave)enemyBullets.get(i);
			double currentDistance = Utils.findDistance(b.current,b.start);			
			int currentGF = (int)Utils.findGF(b.angle,Utils.absoluteBearing(b.start,theBullet),b.escape,MIDDLE_FACTOR);
			double myDistance = Utils.findDistance(theBullet,b.start);
			// Make sure we've got the right bullet and a reasonable angle
			if (Math.abs(myDistance-currentDistance) < 40 && currentGF > 1) {				
				updateStats(currentGF,i,true);
			}
		}
		System.out.println();
		
	}
	// Update the arrays
	public void updateStats(int currentGF,int j, boolean BHB) {		
		EnemyWave b = (EnemyWave)enemyBullets.get(j);
			// If we need to prepopulate one...
			int stillZero = 1;
			int otherStillZero = 1;
			for (int i = 0; i < TOTAL_FACTORS; i++) {
				// Roll some
				recentHits[i] *= 0.5;
				b.recentSegment[i] *= 0.75;
				b.patternHits[i] *= 0.75;
				if (b.patternHits[i] > 0) otherStillZero = 0;				
				if (b.recentSegment[i] > 0) stillZero = 0;
				// Don't count bullet hit bullet events in the overall stats
				if (!BHB) allHits[i] *= allHits[0] / (allHits[0]+1);
				if (!BHB) b.allSegment[i] *= b.allSegment[0] / (b.allSegment[0]+1);
			}			
			System.out.print(currentGF + ".");
			// Now add to the right GF and it's neighbors
			if (stillZero == 1) b.recentSegment[currentGF] = 1;
			else {
				b.recentSegment[currentGF]+=0.19;
				b.recentSegment[currentGF-1]+=0.03;
				b.recentSegment[currentGF+1]+=0.03;
			}
			if (!BHB) b.allSegment[0]++;
			if (!BHB) b.allSegment[currentGF]+= 1/b.allSegment[0];		
				
			if (!BHB) allHits[0]++;
			if (!BHB) allHits[currentGF] += 1/allHits[0];
			
			if (otherStillZero == 1) b.patternHits[currentGF] = 1;
			else {
				b.patternHits[currentGF]+= 0.19;
				b.patternHits[currentGF-1]+= 0.03;
				b.patternHits[currentGF+1]+= 0.03;
			}
			
			recentHits[currentGF]+=0.3;
			recentHits[currentGF-1]+=0.1;
			recentHits[currentGF+1]-=0.1;	
					
			enemyBullets.remove(j);
	}
	
}

// The class we use to surf and its wonderful variables
class EnemyWave {
	
	double[] recentSegment;
	double[] allSegment;
	double[] patternHits;
	double velocity;
	double angle;
	double escape;
	long startTime;
	Point2D start;
	Point2D current;
	
}