/*
 * Decompiled with CFR 0.152.
 */
package xander.cat.group.rem;

import java.util.HashMap;
import java.util.Map;
import xander.core.gun.power.PowerSelector;
import xander.core.track.Snapshot;

public class REMPowerSelector
implements PowerSelector {
    private Map<String, PowerSelector> altPowerSelectors = new HashMap<String, PowerSelector>();
    private PowerSelector basePowerSelector;
    private double minPower;
    private double maxPower;
    private PowerSelector lastPowerSelector;

    public REMPowerSelector(PowerSelector basePowerSelector) {
        this.basePowerSelector = basePowerSelector;
        this.minPower = basePowerSelector.getMinimumPower();
        this.maxPower = basePowerSelector.getMaximumPower();
    }

    public void useAlternate(PowerSelector altPowerSelector, String name) {
        this.altPowerSelectors.put(name, altPowerSelector);
        this.minPower = Math.min(this.minPower, altPowerSelector.getMinimumPower());
        this.maxPower = Math.max(this.maxPower, altPowerSelector.getMaximumPower());
    }

    @Override
    public double getFirePower(Snapshot target) {
        PowerSelector powerSelector = this.altPowerSelectors.get(target.getName());
        if (powerSelector == null) {
            powerSelector = this.basePowerSelector;
        }
        this.lastPowerSelector = powerSelector;
        return powerSelector.getFirePower(target);
    }

    @Override
    public double getMinimumPower() {
        return this.minPower;
    }

    @Override
    public double getMaximumPower() {
        return this.maxPower;
    }

    @Override
    public boolean isAutoAdjustAllowed() {
        if (this.lastPowerSelector != null) {
            return this.lastPowerSelector.isAutoAdjustAllowed();
        }
        return false;
    }
}

