/*
 * Decompiled with CFR 0.152.
 */
package xander.core.gun;

import java.util.List;
import xander.core.Configuration;
import xander.core.gun.Aim;
import xander.core.gun.AutoFireCondition;
import xander.core.gun.Gun;
import xander.core.gun.GunController;
import xander.core.gun.XanderGun;
import xander.core.gun.targeter.HeadOnTargeter;
import xander.core.track.Snapshot;

public class DisabledRobotGun
implements Gun {
    private XanderGun headOnGun;
    private List<AutoFireCondition> autoFireConditions;

    public DisabledRobotGun(Configuration configuration) {
        this.headOnGun = new XanderGun(new HeadOnTargeter(), configuration.getDisabledOpponentPowerSelector());
        this.autoFireConditions = configuration.getAutoFireConditions();
    }

    @Override
    public String getName() {
        return "Disabled Robot Gun";
    }

    @Override
    public void onRoundBegin() {
    }

    @Override
    public boolean fireAt(Snapshot target, Snapshot myself, GunController gunController) {
        return this.headOnGun.fireAt(target, myself, gunController);
    }

    @Override
    public Aim getAim(Snapshot target, Snapshot myself) {
        return this.headOnGun.getAim(target, myself);
    }

    @Override
    public boolean canFireAt(Snapshot target) {
        if (this.autoFireConditions != null) {
            for (AutoFireCondition condition : this.autoFireConditions) {
                if (condition.isSatisfied(target)) continue;
                return false;
            }
        }
        return this.headOnGun.canFireAt(target);
    }
}

