/*
 * Decompiled with CFR 0.152.
 */
package xander.gfws.data;

import xander.gfws.data.AgeRollFunction;
import xander.gfws.distributer.TriangleDistributer;
import xander.gfws.distributer.WaveDistributer;
import xander.gfws.distributer.WeightDistributer;
import xander.gfws.modifier.FactorArrayModifier;
import xander.gfws.modifier.HeadOnFactorArrayModifier;
import xander.gfws.modifier.LinearFactorArrayModifier;

public class FactorArrayParms {
    WeightDistributer distributer;
    double weight = 3.0;
    FactorArrayModifier arrayInitializer;
    int maxDataPointsForUsingArrayInitializer = 0;
    boolean useFlattener = false;
    double useFlattenerOnHitPercentage;
    double useFlattenerVisitPercentage;
    int useFlattenerEarliestRound;
    int flattenerOnCount;
    int flattenerOffCount;
    boolean useBulletShadows = true;
    boolean varyWeightByAge = false;
    boolean varyWeightByDistance = false;
    boolean varyWeightBySearchDistance = false;
    double varyWeightBySearchDistanceMinimum = 0.1;
    Double varyWeightBySearchDistanceMinMaxDistance = null;
    AgeRollFunction varyWeightByAgeFunction;
    double minAgeWeightPercent = 0.01;
    boolean varyWeightByMEA = false;
    boolean offensive;

    public FactorArrayParms(boolean offensive) {
        this.offensive = offensive;
        if (offensive) {
            this.distributer = new TriangleDistributer();
            this.arrayInitializer = new LinearFactorArrayModifier(this.distributer, this.weight);
        } else {
            this.distributer = new WaveDistributer();
            this.arrayInitializer = new HeadOnFactorArrayModifier(this.distributer, this.weight);
        }
    }

    public boolean isOffensive() {
        return this.offensive;
    }

    public WeightDistributer getDistributer() {
        return this.distributer;
    }

    public void setDistributer(WeightDistributer distributer) {
        this.distributer = distributer;
    }

    public void setMinAgeWeightPercent(double minAgeWeightPercent) {
        this.minAgeWeightPercent = minAgeWeightPercent;
    }

    public void setUseFlattener(boolean useFlattener, double opponentHitPercentage, double visitPercentage, int earliestRound) {
        this.useFlattener = useFlattener;
        this.useFlattenerOnHitPercentage = opponentHitPercentage;
        this.useFlattenerEarliestRound = earliestRound;
        this.useFlattenerVisitPercentage = visitPercentage;
    }

    public void setUseBulletShadows(boolean useBulletShadows) {
        this.useBulletShadows = useBulletShadows;
    }

    public void setVaryWeightByAgeFunction(AgeRollFunction varyWeightByAgeFunction) {
        this.varyWeightByAgeFunction = varyWeightByAgeFunction;
        this.varyWeightByAge = this.varyWeightByAgeFunction != null;
    }

    public AgeRollFunction getVaryWeightByAgeFunction() {
        return this.varyWeightByAgeFunction;
    }

    public boolean isVaryWeightByDistance() {
        return this.varyWeightByDistance;
    }

    public void setVaryWeightByDistance(boolean varyWeightByDistance) {
        this.varyWeightByDistance = varyWeightByDistance;
    }

    public void setArrayInitializer(FactorArrayModifier arrayInitializer) {
        this.arrayInitializer = arrayInitializer;
    }

    public void setMaxDataPointsForUsingArrayInitializer(int maxDataPointsForUsingArrayInitializer) {
        this.maxDataPointsForUsingArrayInitializer = maxDataPointsForUsingArrayInitializer;
    }

    public boolean isVaryWeightByMEA() {
        return this.varyWeightByMEA;
    }

    public void setVaryWeightByMEA(boolean varyWeightByMEA) {
        this.varyWeightByMEA = varyWeightByMEA;
    }

    public boolean isVaryWeightBySearchDistance() {
        return this.varyWeightBySearchDistance;
    }

    public void setVaryWeightBySearchDistance(boolean varyWeightBySearchDistance) {
        this.varyWeightBySearchDistance = varyWeightBySearchDistance;
    }

    public void setVaryWeightBySearchDistance(boolean varyWeightBySearchDistance, double minimumValueMultiplier) {
        this.varyWeightBySearchDistance = varyWeightBySearchDistance;
        this.varyWeightBySearchDistanceMinimum = minimumValueMultiplier;
    }

    public double getVaryWeightBySearchDistanceMinimum() {
        return this.varyWeightBySearchDistanceMinimum;
    }

    public void setVaryWeightBySearchDistanceMinMaxDistance(Double minMaxDistance) {
        this.varyWeightBySearchDistanceMinMaxDistance = minMaxDistance;
    }
}

