/*
 * Decompiled with CFR 0.152.
 */
package mue;

import java.awt.Color;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import mue.AntiSurfGun;
import mue.BulletData;
import mue.EnemyWave;
import mue.EvadeMovement;
import mue.GuessFactorGun;
import mue.GunArray;
import mue.Movement;
import mue.RobotBase;
import mue.RobotData;
import mue.Util;
import mue.WaveSurfingMovement;
import robocode.AdvancedRobot;
import robocode.BulletHitBulletEvent;
import robocode.BulletHitEvent;
import robocode.DeathEvent;
import robocode.Event;
import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;
import robocode.HitWallEvent;
import robocode.WinEvent;

public final class Ascendant
extends RobotBase {
    protected static final double MIN_CIRCLE_DISTANCE = 300.0;
    protected static final double MAX_CIRCLE_DISTANCE = 400.0;
    protected static final double EVADE_DISTANCE = 70.0;
    protected static final double DISTANCE_OFFSET = 20.0;
    protected static boolean targetingChallenge = false;
    protected static boolean movementChallenge = false;
    protected static final float ROLLING_FACTOR = 0.02f;
    protected static double enemyDamage = 0.0;
    protected static double enemyEnergy = 0.0;
    protected static int enemyShots = 0;
    protected static int enemyHits = 0;
    protected static double battleScore = 0.0;
    protected static double enemyBattleScore = 0.0;
    protected static double energyDiff = 0.0;
    protected static int encounteredBullets = 0;
    protected static int undetectedEncounteredBullets = 0;
    protected static long wallHits = 0L;
    protected GunArray gunArray;
    protected GuessFactorGun guessFactorGun;
    protected AntiSurfGun antiSurfGun;
    protected EvadeMovement evadeMovement;
    protected WaveSurfingMovement waveSurfingMovement;
    protected Movement currentMovement;
    protected double score;
    protected double enemyScore;
    protected List delayedBulletEvents;

    protected void init() {
        super.init();
        Color color = new Color(100, 100, 100);
        Color color2 = new Color(50, 50, 50);
        Color color3 = new Color(150, 150, 150);
        this.setColors(color, color2, color3);
        this.configure();
        this.gunArray = new GunArray((AdvancedRobot)this, !this.isSilent(), targetingChallenge);
        this.guessFactorGun = new GuessFactorGun((AdvancedRobot)this);
        this.antiSurfGun = new AntiSurfGun((AdvancedRobot)this);
        this.gunArray.addGun(this.guessFactorGun, 1.0f, 0.02f, 0.02f);
        this.gunArray.addGun(this.antiSurfGun, 0.0f, 0.02f, 0.02f);
        this.evadeMovement = new EvadeMovement((AdvancedRobot)this, this.getKnowledge());
        this.waveSurfingMovement = new WaveSurfingMovement((AdvancedRobot)this, this.getKnowledge());
        this.waveSurfingMovement.setMinDistance(300.0);
        this.waveSurfingMovement.setMaxDistance(400.0);
        this.currentMovement = null;
        this.delayedBulletEvents = new ArrayList(5);
        this.score = 0.0;
        this.enemyScore = 0.0;
    }

    protected void configure() {
        if (this.getRoundNum() == 0) {
            this.setSilent(true);
            File file = this.getDataFile("debug.properties");
            if (file.exists()) {
                try {
                    Properties properties = new Properties();
                    FileInputStream fileInputStream = new FileInputStream(file);
                    properties.load(fileInputStream);
                    if ("false".equals(properties.getProperty("silent"))) {
                        this.setSilent(false);
                    }
                    if ("true".equals(properties.getProperty("targetingChallenge"))) {
                        targetingChallenge = true;
                    }
                    if ("true".equals(properties.getProperty("movementChallenge"))) {
                        movementChallenge = true;
                    }
                    this.println("configuration (according to debug.properties):");
                    this.println("  silent = " + this.isSilent());
                    this.println("  targetingChallenge = " + targetingChallenge);
                    this.println("  movementChallenge = " + movementChallenge);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    Util.addWarning("Could not open debug.properties");
                }
                catch (IOException iOException) {
                    Util.addWarning("Exception when parsing debug.properties: " + iOException.getMessage());
                }
            }
        }
    }

    protected void action() {
        RobotData robotData = null;
        while (true) {
            if (this.getKnowledge().numberOfLivingOpponents() > 0) {
                robotData = this.getKnowledge().getNearestLivingOpponent();
            }
            this.doRadar(robotData);
            this.doMovement(robotData);
            if (!movementChallenge) {
                this.gunArray.doGun(robotData);
            }
            this.execute();
            Iterator iterator = this.delayedBulletEvents.iterator();
            while (iterator.hasNext()) {
                Event event = (Event)iterator.next();
                if (event instanceof BulletHitBulletEvent) {
                    this.onDelayedBulletHitBullet((BulletHitBulletEvent)event);
                    continue;
                }
                if (event instanceof HitByBulletEvent) {
                    this.onDelayedHitByBullet((HitByBulletEvent)event);
                    continue;
                }
                Util.addWarning("unexpected event found : " + event.getClass());
            }
            this.delayedBulletEvents.clear();
        }
    }

    protected void doRadar(RobotData robotData) {
        if (robotData == null || !robotData.isAlive()) {
            this.setTurnRadarLeft(75.0);
        } else {
            double d = Util.direction(this.getX(), this.getY(), robotData.getX(), robotData.getY());
            d = Util.relativeAngle(this.getRadarHeading(), d);
            if (d > 0.0) {
                this.setTurnRadarRight(d + 10.0);
            } else {
                this.setTurnRadarRight(d - 10.0);
            }
        }
    }

    protected void doMovement(RobotData robotData) {
        if (targetingChallenge) {
            return;
        }
        Movement movement = this.currentMovement;
        this.currentMovement = null;
        if (robotData == null) {
            return;
        }
        double d = robotData.getDistance();
        if (d < 70.0 || movement == this.evadeMovement && d < 90.0) {
            this.evadeMovement.setOpponent(robotData.getName());
            this.currentMovement = this.evadeMovement;
        } else {
            this.waveSurfingMovement.setOpponent(robotData.getName());
            this.currentMovement = this.waveSurfingMovement;
        }
        if (movement != this.currentMovement) {
            this.currentMovement.reset();
        }
        if (!this.currentMovement.move()) {
            Util.addWarning("selected movement not configured correctly!");
            this.currentMovement = null;
        }
    }

    public void onHitByBullet(HitByBulletEvent hitByBulletEvent) {
        super.onHitByBullet(hitByBulletEvent);
        this.delayedBulletEvents.add(hitByBulletEvent);
    }

    private void onDelayedHitByBullet(HitByBulletEvent hitByBulletEvent) {
        ++encounteredBullets;
        if (!this.waveSurfingMovement.adapt(hitByBulletEvent.getBullet(), hitByBulletEvent.getTime(), true)) {
            ++undetectedEncounteredBullets;
        }
        double d = Util.getBulletDamage(hitByBulletEvent.getPower());
        this.enemyScore += d;
        enemyDamage += d;
        ++enemyHits;
    }

    public void onBulletHitBullet(BulletHitBulletEvent bulletHitBulletEvent) {
        super.onBulletHitBullet(bulletHitBulletEvent);
        this.delayedBulletEvents.add(bulletHitBulletEvent);
    }

    private void onDelayedBulletHitBullet(BulletHitBulletEvent bulletHitBulletEvent) {
        if (!this.getName().equals(bulletHitBulletEvent.getBullet().getName())) {
            ++encounteredBullets;
            if (!this.waveSurfingMovement.adapt(bulletHitBulletEvent.getBullet(), bulletHitBulletEvent.getTime(), false)) {
                ++undetectedEncounteredBullets;
            }
        }
        if (!this.getName().equals(bulletHitBulletEvent.getHitBullet().getName())) {
            ++encounteredBullets;
            if (!this.waveSurfingMovement.adapt(bulletHitBulletEvent.getHitBullet(), bulletHitBulletEvent.getTime(), false)) {
                ++undetectedEncounteredBullets;
            }
        }
    }

    public void onBulletHit(BulletHitEvent bulletHitEvent) {
        super.onBulletHit(bulletHitEvent);
        this.score += Util.getBulletDamage(bulletHitEvent.getBullet().getPower());
        this.gunArray.onBulletHit(bulletHitEvent.getBullet(), bulletHitEvent.getName());
    }

    public void onHitRobot(HitRobotEvent hitRobotEvent) {
        super.onHitRobot(hitRobotEvent);
        if (hitRobotEvent.isMyFault()) {
            this.score += 1.2;
        } else {
            this.enemyScore += 1.2;
        }
    }

    public void onHitWall(HitWallEvent hitWallEvent) {
        super.onHitWall(hitWallEvent);
        ++wallHits;
    }

    public void onBulletDetected(BulletData bulletData) {
        enemyEnergy += bulletData.getPower();
        ++enemyShots;
        EnemyWave enemyWave = new EnemyWave(this.waveSurfingMovement, (AdvancedRobot)this, this.getKnowledge(), bulletData.getOriginX(), bulletData.getOriginY());
        enemyWave.fire(bulletData.getPower(), true);
    }

    public void onWin(WinEvent winEvent) {
        RobotData robotData = this.getKnowledge().getNearestLivingOpponent();
        if (robotData != null) {
            this.score += robotData.getEnergy();
        }
        this.score = this.score * 1.2 + 60.0;
        super.onWin(winEvent);
    }

    public void onDeath(DeathEvent deathEvent) {
        HitByBulletEvent hitByBulletEvent;
        Iterator iterator = this.getHitByBulletEvents().iterator();
        while (iterator.hasNext()) {
            hitByBulletEvent = (HitByBulletEvent)iterator.next();
            this.onHitByBullet(hitByBulletEvent);
            this.onDelayedHitByBullet(hitByBulletEvent);
        }
        iterator = this.getBulletHitEvents().iterator();
        while (iterator.hasNext()) {
            this.onBulletHit((BulletHitEvent)iterator.next());
        }
        iterator = this.getBulletHitBulletEvents().iterator();
        while (iterator.hasNext()) {
            hitByBulletEvent = (BulletHitBulletEvent)iterator.next();
            this.onBulletHitBullet((BulletHitBulletEvent)hitByBulletEvent);
            this.onDelayedBulletHitBullet((BulletHitBulletEvent)hitByBulletEvent);
        }
        this.enemyScore *= 1.2;
        if (this.getOthers() > 0) {
            this.enemyScore += 60.0;
        }
        super.onDeath(deathEvent);
    }

    protected void onEndOfRound() {
        super.onEndOfRound();
        enemyBattleScore += this.enemyScore;
        battleScore += this.score;
        energyDiff += this.getKnowledge().getEnergyBalance();
    }

    protected void onEndOfBattle() {
        if (!this.isSilent()) {
            Set set = this.getKnowledge().getOpponentNames();
            if (set.size() == 1) {
                String string = (String)set.iterator().next();
                try {
                    List list = this.readFile(string + ".mov");
                    List list2 = this.waveSurfingMovement.applyResults(list);
                    this.writeFile(string + ".mov", list2);
                    list = this.readFile("overall.mov");
                    list2 = this.waveSurfingMovement.applyResults(list);
                    this.writeFile("overall.mov", list2);
                }
                catch (Exception exception) {
                    Util.addWarning("exception while writing movement performance files: " + exception.getMessage());
                }
            }
            double d = 0.0;
            if (this.getNumRounds() > 0) {
                d = (double)Math.round(energyDiff * 10000.0 / (double)(this.getNumRounds() * 175)) / 100.0;
            }
            this.println("performance: " + d);
            d = 0.0;
            if (enemyEnergy > 0.0) {
                d = enemyDamage / enemyEnergy;
            }
            this.println("enemy damage ratio: " + d + " (" + Math.round(enemyDamage) + " / " + Math.round(enemyEnergy) + ")");
            d = 0.0;
            if (enemyShots > 0) {
                d = (double)enemyHits / (double)enemyShots;
            }
            this.println("enemy hit ratio: " + d + " (" + enemyHits + " / " + enemyShots + ")");
            d = 0.0;
            if (enemyShots > 0) {
                d = enemyEnergy / (double)enemyShots;
            }
            this.println("enemy average fire power: " + d + " (using " + enemyShots + " shots)");
            this.println("");
            this.println(this.waveSurfingMovement.evaluation());
            this.println(this.gunArray.evaluate());
            d = 0.0;
            if (enemyBattleScore + battleScore > 0.0) {
                d = Math.floor(battleScore * 1000000.0 / (enemyBattleScore + battleScore)) / 10000.0;
            }
            this.println("score: " + d + "% (" + Math.round(battleScore) + " / " + Math.round(enemyBattleScore) + ")");
            this.println("");
            d = 0.0;
            if (encounteredBullets > 0) {
                d = (double)undetectedEncounteredBullets / (double)encounteredBullets;
            }
            this.println("undetected bullets encountered: " + d + " (" + undetectedEncounteredBullets + " / " + encounteredBullets + ")");
            this.println("wallHits: " + wallHits);
        }
        super.onEndOfBattle();
    }
}

