/*
 * Decompiled with CFR 0.152.
 */
package simonton.core;

import robocode.Bullet;
import simonton.core.Bot;
import simonton.utils.Util;

public class BulletWrapper {
    private Bot bot;
    private Bullet bullet;
    private double power;

    public BulletWrapper(Bot bot, double power) {
        assert (bot.getGunHeat() == 0.0 && !(bot.getEnergy() <= 0.0));
        this.bot = bot;
        this.power = power;
    }

    public double getHeading() {
        if (this.bullet == null) {
            return this.bot.getGunHeading();
        }
        return this.bullet.getHeading();
    }

    public double getHeadingRadians() {
        if (this.bullet == null) {
            return this.bot.getGunHeadingRadians();
        }
        return this.bullet.getHeadingRadians();
    }

    public String getName() {
        return this.bot.getName();
    }

    public double getPower() {
        return this.power;
    }

    public double getVelocity() {
        return Util.getBulletSpeed(this.power);
    }

    public String getVictim() {
        if (this.bullet == null) {
            return null;
        }
        return this.bullet.getVictim();
    }

    public double getX() {
        if (this.bullet == null) {
            return this.bot.getX();
        }
        return this.bullet.getX();
    }

    public double getY() {
        if (this.bullet == null) {
            return this.bot.getY();
        }
        return this.bullet.getY();
    }

    public boolean isActive() {
        if (this.bullet == null) {
            return true;
        }
        return this.bullet.isActive();
    }
}

