/*
 * Decompiled with CFR 0.152.
 */
package simonton.utils;

import java.util.Arrays;
import java.util.Collections;

public class FastMath {
    public static final double THR_60 = Math.PI * 2;
    public static final double TWO_70 = 4.71238898038469;
    public static final double ONE_80 = Math.PI;
    public static final double NINETY = 1.5707963267948966;
    public static final double FOUR_5 = 0.7853981633974483;
    public static final double ZEEROE = Math.PI * 2;
    public static double[] cos = new double[360];
    public static double[] sin = new double[360];
    private static double[] sqrt = new double[1500];

    static {
        int i = 0;
        while (i < 360) {
            FastMath.cos[i] = Math.cos(Math.toRadians(i));
            FastMath.sin[i] = Math.sin(Math.toRadians(i));
            ++i;
        }
        i = 0;
        while (i < 1500) {
            FastMath.sqrt[i] = Math.sqrt(i);
            ++i;
        }
    }

    public static int abs(int i) {
        return i >= 0 ? i : -i;
    }

    public static double abs(double d) {
        return d >= 0.0 ? d : -d;
    }

    public static int floor(double d) {
        return (int)Math.floor(d);
    }

    public static int ceil(double d) {
        return (int)Math.ceil(d);
    }

    public static int square(int i) {
        return i * i;
    }

    public static double square(double d) {
        return d * d;
    }

    public static double cube(double d) {
        return d * d * d;
    }

    public static double doubleSquare(double d) {
        d *= d;
        return d * d;
    }

    public static double sqrt(double d) {
        return Math.sqrt(d);
    }

    public static double sqrt(int i) {
        return sqrt[i];
    }

    public static double cbrt(double d) {
        return Math.cbrt(d);
    }

    public static double hypot(double dx, double dy) {
        return Math.hypot(dx, dy);
    }

    public static double toDegrees(double radians) {
        return radians * 57.29577951308232;
    }

    public static double toRadians(double degrees) {
        return degrees * (Math.PI / 180);
    }

    public static int cannonize(int angle) {
        if (angle < 0) {
            return (360 + angle) % 360;
        }
        return angle % 360;
    }

    public static double cannonize(double angle) {
        if (angle < 0.0) {
            return Math.PI * 2 + angle % (Math.PI * 2);
        }
        return angle % (Math.PI * 2);
    }

    public static int normalize(int angle) {
        return FastMath.cannonize(angle + 180) - 180;
    }

    public static double normalize(double angle) {
        return FastMath.cannonize(angle + Math.PI) - Math.PI;
    }

    public static double cos(int angle) {
        return cos[FastMath.cannonize(angle)];
    }

    public static double sin(int angle) {
        return sin[FastMath.cannonize(angle)];
    }

    public static double cos(double angle) {
        return Math.cos(angle);
    }

    public static double sin(double angle) {
        return Math.sin(angle);
    }

    public static double tan(double angle) {
        return Math.tan(angle);
    }

    public static double asin(double d) {
        return Math.asin(d);
    }

    public static double acos(double d) {
        return Math.acos(d);
    }

    public static double atan2(double x, double y) {
        return Math.atan2(x, y);
    }

    public static boolean equal(double d1, double d2) {
        return Math.abs(d1 - d2) < 1.0E-5;
    }

    public static double roll(double oldVal, double newVal, double rollingDepth) {
        return (rollingDepth * oldVal + newVal) / (rollingDepth + 1.0);
    }

    public static int sign(int i) {
        return i >= 0 ? 1 : -1;
    }

    public static int sign(double d) {
        return d >= 0.0 ? 1 : -1;
    }

    public static int max(int i1, int i2) {
        return i1 <= i2 ? i2 : i1;
    }

    public static double max(double d1, double d2) {
        return d1 <= d2 ? d2 : d1;
    }

    public static int min(int i1, int i2) {
        return i1 >= i2 ? i2 : i1;
    }

    public static double min(double d1, double d2) {
        return d1 >= d2 ? d2 : d1;
    }

    public static Double min(Double[] vals) {
        return Collections.min(Arrays.asList(vals));
    }

    public static double bound(double value, double min, double max) {
        if (value <= min) {
            return min;
        }
        if (value >= max) {
            return max;
        }
        return value;
    }

    public static int bound(int value, int min, int max) {
        if (value <= min) {
            return min;
        }
        if (value >= max) {
            return max;
        }
        return value;
    }

    public static double random() {
        return Math.random();
    }

    public static double random(double min, double max) {
        return (max - min) * Math.random() + min;
    }

    public static int randomInt(int max) {
        return FastMath.randomInt(0, max);
    }

    public static int randomInt(int min, int max) {
        return (int)((double)(max - min + 1) * Math.random()) + min;
    }

    public static boolean randomBool(double probability) {
        return Math.random() < probability;
    }

    protected double getEntropy(long[] visitCounts, long totalVisits) {
        double entropy = 0.0;
        int x = 0;
        while (x < visitCounts.length) {
            if (visitCounts[x] != 0L) {
                double p = (double)visitCounts[x] / (double)totalVisits;
                entropy += p * Math.log(1.0 / p);
            }
            ++x;
        }
        return entropy;
    }
}

