/*
 * Decompiled with CFR 0.152.
 */
package Krabb.sliNk;

import Krabb.sliNk.BasicGun;
import Krabb.sliNk.Data;
import Krabb.sliNk.Garm;
import Krabb.sliNk.Gun;
import Krabb.sliNk.MovementStatistics;
import Krabb.sliNk.MyBullet;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import robocode.Condition;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;

public class RaikoGun
extends BasicGun {
    private static double bearingDirection = 1.0;
    private static double lastLatVel;
    private static double lastVelocity;
    private static double enemyEnergy;
    private static double enemyDistance;
    private static double lastVChangeTime;
    private static double enemyLatVel;
    private static double enemyVelocity;
    private static Point2D.Double enemyLocation;
    private static final int GF_ZERO = 15;
    private static final int GF_ONE = 30;
    private static String enemyName;
    private static int[][][][][][] guessFactors;
    private Gun bot;
    private double bulletPower = 0.0;
    private boolean virtual = true;

    static {
        guessFactors = new int[3][5][3][3][8][31];
    }

    public void newRound(Gun robot) {
        this.bot = robot;
    }

    public void run() {
        this.bot.setAdjustGunForRobotTurn(true);
        this.bot.setAdjustRadarForGunTurn(true);
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        if (enemyName == null) {
            enemyName = e.getName();
        }
        Point2D.Double robotLocation = new Point2D.Double(this.bot.getX(), this.bot.getY());
        double enemyAbsoluteBearing = this.bot.getHeadingRadians() + e.getBearingRadians();
        enemyDistance = e.getDistance();
        enemyLocation = RaikoGun.projectMotion(robotLocation, enemyAbsoluteBearing, enemyDistance);
        enemyEnergy = e.getEnergy();
        Rectangle2D.Double BF = new Rectangle2D.Double(18.0, 18.0, 764.0, 564.0);
        MicroWave w = new MicroWave();
        lastLatVel = enemyLatVel;
        lastVelocity = enemyVelocity;
        enemyVelocity = e.getVelocity();
        enemyLatVel = enemyVelocity * Math.sin(e.getHeadingRadians() - enemyAbsoluteBearing);
        int distanceIndex = (int)enemyDistance / 140;
        this.bulletPower = distanceIndex == 0 ? 3 : 2;
        double theta = Math.min(this.bot.getEnergy() / 4.0, Math.min(enemyEnergy / 4.0, this.bulletPower));
        if (theta == this.bulletPower) {
            this.bot.addCustomEvent(w);
        }
        this.bulletPower = theta;
        w.bulletVelocity = 20.0 - 3.0 * this.bulletPower;
        int accelIndex = (int)Math.round(Math.abs(enemyLatVel) - Math.abs(lastLatVel));
        if (enemyLatVel != 0.0) {
            bearingDirection = enemyLatVel > 0.0 ? 1 : -1;
        }
        w.bearingDirection = bearingDirection * Math.asin(8.0 / w.bulletVelocity) / 15.0;
        double d = lastVChangeTime;
        lastVChangeTime = d + 1.0;
        double moveTime = w.bulletVelocity * d / enemyDistance;
        int bestGF = moveTime < 0.1 ? 1 : (moveTime < 0.3 ? 2 : (moveTime < 1.0 ? 3 : 4));
        int vIndex = (int)Math.abs(enemyLatVel / 3.0);
        if (Math.abs(Math.abs(enemyVelocity) - Math.abs(lastVelocity)) > 0.6) {
            lastVChangeTime = 0.0;
            bestGF = 0;
            accelIndex = (int)Math.round(Math.abs(enemyVelocity) - Math.abs(lastVelocity));
            vIndex = (int)Math.abs(enemyVelocity / 3.0);
        }
        if (accelIndex != 0) {
            accelIndex = accelIndex > 0 ? 1 : 2;
        }
        w.firePosition = robotLocation;
        w.enemyAbsBearing = enemyAbsoluteBearing;
        w.waveGuessFactors = guessFactors[accelIndex][bestGF][vIndex][BF.contains(RaikoGun.projectMotion(robotLocation, enemyAbsoluteBearing + w.bearingDirection * 15.0, enemyDistance)) ? 0 : (BF.contains(RaikoGun.projectMotion(robotLocation, enemyAbsoluteBearing + 0.5 * w.bearingDirection * 15.0, enemyDistance)) ? 1 : 2)][distanceIndex];
        bestGF = 15;
        int gf = 30;
        while (gf >= 0 && enemyEnergy > 0.0) {
            if (w.waveGuessFactors[gf] > w.waveGuessFactors[bestGF]) {
                bestGF = gf;
            }
            --gf;
        }
        this.bot.setTurnGunRightRadians(Utils.normalRelativeAngle((double)(enemyAbsoluteBearing - this.bot.getGunHeadingRadians() + w.bearingDirection * (double)(bestGF - 15))));
        this.virtual = !(this.bot.getEnergy() > 1.0) && distanceIndex != 0;
    }

    private static Point2D.Double projectMotion(Point2D.Double loc, double heading, double distance) {
        return new Point2D.Double(loc.x + distance * Math.sin(heading), loc.y + distance * Math.cos(heading));
    }

    private static double absoluteBearing(Point2D.Double source, Point2D.Double target) {
        return Math.atan2(target.x - source.x, target.y - source.y);
    }

    public MyBullet aim(MyBullet bullet_next, Gun gun) {
        if (bullet_next != null && this.bot.getGunHeat() == 0.0 && this.bot.getEnergy() >= 0.1) {
            gun.setFire(bullet_next, this.virtual);
        }
        if (Garm.getFirstLivingEnemy() != null && Garm.getFirstLivingEnemy().getNewestStats() != null) {
            MyBullet bullet_new = new MyBullet(this.bulletPower, this.bot.getGunHeadingRadians(), Data.stats_my, this.bot);
            bullet_new.enemy_aim = Garm.getFirstBot().name;
            int statis = 0;
            while (statis < MovementStatistics.statistics_n) {
                bullet_new.setAimAngle(0, Gun.gunorientation_next, statis);
                ++statis;
            }
            return bullet_new;
        }
        return null;
    }

    class MicroWave
    extends Condition {
        Point2D.Double firePosition;
        int[] waveGuessFactors;
        double enemyAbsBearing;
        double distance;
        double bearingDirection;
        double bulletVelocity;

        MicroWave() {
        }

        public boolean test() {
            double d;
            this.distance += this.bulletVelocity;
            if (enemyLocation.distance(this.firePosition) <= d + this.bulletVelocity) {
                try {
                    int n = (int)Math.round(Utils.normalRelativeAngle((double)(RaikoGun.absoluteBearing(this.firePosition, enemyLocation) - this.enemyAbsBearing)) / this.bearingDirection + 15.0);
                    this.waveGuessFactors[n] = this.waveGuessFactors[n] + 1;
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    // empty catch block
                }
                RaikoGun.this.bot.removeCustomEvent(this);
            }
            return false;
        }
    }
}

