/*
 * Decompiled with CFR 0.152.
 */
package florent;

import florent.Wave;
import java.awt.geom.Point2D;
import robocode.AdvancedRobot;
import robocode.Condition;

public class MyEnemyWave
extends Wave {
    private static AdvancedRobot robot;
    static Point2D targetLocation;
    private static MyEnemyWave surfing;
    private boolean fired;
    private int predictedGf;
    private Point2D.Double pmLocation;

    public MyEnemyWave(Point2D gunLocation, double fireTime, double bearing, double power, double bearingDirection, boolean fired) {
        super(gunLocation, fireTime, bearing, power, bearingDirection);
        this.fired = fired;
    }

    public boolean test() {
        MyEnemyWave.synch();
        if (this.distanceToImpact(targetLocation, time) < 18.0) {
            this.arrived(targetLocation);
        }
        if (this.distanceToImpact(targetLocation, time) < -18.0) {
            robot.removeCustomEvent((Condition)this);
        }
        if (this.distanceToImpact(targetLocation, time) < -40.0) {
            this.passed();
        }
        if (this.fired) {
            this.notArrived();
        }
        return false;
    }

    private void notArrived() {
        int i = 0;
        while (i < this.commandCount) {
            this.commands[i].doWhileNotArrived(this);
            ++i;
        }
    }

    private void passed() {
        int i = 0;
        while (i < this.commandCount) {
            this.commands[i].doOnPassed(this);
            ++i;
        }
    }

    public static void synch() {
        if (time == context.getTime()) {
            return;
        }
        time = context.getTime();
        targetLocation = context.getMyLocation();
    }

    public static void setTargetLocation(Point2D targetLocation) {
        MyEnemyWave.targetLocation = targetLocation;
    }

    public static void setRobot(AdvancedRobot robot) {
        MyEnemyWave.robot = robot;
    }

    public static MyEnemyWave getSurfing() {
        return surfing;
    }

    public double hitBullet(Point2D enemyLocation) {
        double res = super.hitBullet(enemyLocation);
        robot.removeCustomEvent((Condition)this);
        return res;
    }

    public boolean isFired() {
        return this.fired;
    }

    public int getPredictedGf() {
        return this.predictedGf;
    }

    public void setPredictedGf(int predictedGf) {
        this.predictedGf = predictedGf;
    }

    public static double maxEscapeAngle(double velocity) {
        return Math.asin(8.0 / velocity);
    }

    public Point2D.Double getPmLocation() {
        return this.pmLocation;
    }

    public void setPmLocation(Point2D.Double pmLocation) {
        this.pmLocation = pmLocation;
    }
}

