/*
 * Decompiled with CFR 0.152.
 */
package rdm.robots;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import rdm.state.MyBullet;
import rdm.state.entities.BodyState;
import rdm.state.entities.EnemyState;
import rdm.state.entities.GunState;
import rdm.state.entities.InstantState;
import rdm.state.entities.RadarState;
import rdm.state.entities.SelfState;
import rdm.state.entities.WorldState;
import robocode.AdvancedRobot;
import robocode.Bullet;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=2, d1={"\u0000B\n\u0000\n\u0002\u0010\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\u001a\u0016\u0010\t\u001a\u00020\u00012\u0006\u0010\n\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\f\u001a\u0018\u0010\r\u001a\u00020\u00012\u0006\u0010\u000e\u001a\u00020\u00012\u0006\u0010\u000f\u001a\u00020\u0001H\u0002\u001a\u0012\u0010\u0010\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u000b\u001a\u00020\f\u001a\u0012\u0010\u0011\u001a\u00020\u0012*\u00020\u00022\u0006\u0010\u000b\u001a\u00020\f\u001a\u001e\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00010\u0014*\u00020\u00022\u0006\u0010\u000b\u001a\u00020\f\u001a \u0010\u0015\u001a\u00020\u0016*\u00020\u00022\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018\u001a\u001a\u0010\u001a\u001a\u00020\u001b*\u00020\u00022\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u001c\u001a\u00020\u0001\u001a\u0012\u0010\u001d\u001a\u00020\u001b*\u00020\u00022\u0006\u0010\u000b\u001a\u00020\f\u001a\u0012\u0010\u001e\u001a\u00020\u001b*\u00020\u00022\u0006\u0010\u001f\u001a\u00020\u0012\u001a\u001a\u0010\u001e\u001a\u00020\u001b*\u00020\u00022\u0006\u0010 \u001a\u00020\u00012\u0006\u0010!\u001a\u00020\u0001\u001a\u001e\u0010\u001e\u001a\u00020\u001b*\u00020\u00022\u0012\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00010\u0014\"\u0018\u0010\u0000\u001a\u00020\u0001*\u00020\u00028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u0015\u0010\u0005\u001a\u00020\u0006*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\""}, d2={"RADAR_LOCK_FACTOR", "", "Lrobocode/AdvancedRobot;", "getRADAR_LOCK_FACTOR", "(Lrobocode/AdvancedRobot;)D", "canFire", "", "getCanFire", "(Lrobocode/AdvancedRobot;)Z", "calculateEnemyDirection", "headingRadians", "event", "Lrobocode/ScannedRobotEvent;", "calculateNormalDistanceFromWall", "normalX", "normalY", "getBearingFromGun", "getEnemyAbsolutePosition", "Ljava/awt/geom/Point2D;", "getEnemyRelativePosition", "Lkotlin/Pair;", "instantStateOf", "Lrdm/state/entities/InstantState;", "myBullets", "", "Lrobocode/Bullet;", "lockGunOnTarget", "", "prediction", "lockRadarOnTarget", "setMoveTo", "target", "targetX", "targetY", "Commons"})
public final class AdvancedRobotExtensionsKt {
    private static final double getRADAR_LOCK_FACTOR(@NotNull AdvancedRobot $receiver) {
        return 2.0;
    }

    public static final boolean getCanFire(@NotNull AdvancedRobot $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return !($receiver.getGunHeat() > 0.0);
    }

    public static final void setMoveTo(@NotNull AdvancedRobot $receiver, double targetX, double targetY) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        double vectorX = targetX - $receiver.getX();
        double vectorY = targetY - $receiver.getY();
        double angleToTarget = Math.atan2(vectorX, vectorY);
        double targetAngle = Utils.normalRelativeAngle((double)(angleToTarget - $receiver.getHeadingRadians()));
        double distance = Math.hypot(vectorX, vectorY);
        double turnAngle = Math.atan(Math.tan(targetAngle));
        $receiver.setTurnRightRadians(turnAngle);
        if (targetAngle == turnAngle) {
            $receiver.setAhead(distance);
        } else {
            $receiver.setBack(distance);
        }
    }

    public static final void setMoveTo(@NotNull AdvancedRobot $receiver, @NotNull Point2D target) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(target, "target");
        AdvancedRobotExtensionsKt.setMoveTo($receiver, target.getX(), target.getY());
    }

    public static final void setMoveTo(@NotNull AdvancedRobot $receiver, @NotNull Pair<Double, Double> target) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(target, "target");
        AdvancedRobotExtensionsKt.setMoveTo($receiver, ((Number)target.getFirst()).doubleValue(), ((Number)target.getSecond()).doubleValue());
    }

    public static final void lockRadarOnTarget(@NotNull AdvancedRobot $receiver, @NotNull ScannedRobotEvent event) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(event, "event");
        double radarTurn = $receiver.getHeadingRadians() + event.getBearingRadians() - $receiver.getRadarHeadingRadians();
        $receiver.setTurnRadarRightRadians(AdvancedRobotExtensionsKt.getRADAR_LOCK_FACTOR($receiver) * Utils.normalRelativeAngle((double)radarTurn));
    }

    public static final void lockGunOnTarget(@NotNull AdvancedRobot $receiver, @NotNull ScannedRobotEvent event, double prediction) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(event, "event");
        $receiver.setTurnGunRight(AdvancedRobotExtensionsKt.getBearingFromGun($receiver, event) + prediction);
    }

    public static final double getBearingFromGun(@NotNull AdvancedRobot $receiver, @NotNull ScannedRobotEvent event) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(event, "event");
        double absoluteBearing = $receiver.getHeading() + event.getBearing();
        return Utils.normalRelativeAngleDegrees((double)(absoluteBearing - $receiver.getGunHeading()));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final InstantState instantStateOf(@NotNull AdvancedRobot $receiver, @NotNull ScannedRobotEvent event, @NotNull List<? extends Bullet> myBullets) {
        Collection<MyBullet> collection;
        void $receiver$iv$iv;
        void $receiver$iv;
        InstantState instantState;
        SelfState selfState;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(event, "event");
        Intrinsics.checkParameterIsNotNull(myBullets, "myBullets");
        Point2D enemyPosition = AdvancedRobotExtensionsKt.getEnemyAbsolutePosition($receiver, event);
        double enemyNormalPositionX = enemyPosition.getX() / $receiver.getBattleFieldWidth() * 2.0 - 1.0;
        double enemyNormalPositionY = enemyPosition.getY() / $receiver.getBattleFieldHeight() * 2.0 - 1.0;
        double enemyNormalDistanceFromCenter = Math.sqrt(Math.pow(enemyNormalPositionX, 2.0) + Math.pow(enemyNormalPositionY, 2.0));
        double enemyNormalDistanceFromWall = AdvancedRobotExtensionsKt.calculateNormalDistanceFromWall(enemyNormalPositionX, enemyNormalPositionY);
        double enemyLateralVelocity = event.getVelocity() * Math.sin(event.getHeadingRadians() - (event.getBearingRadians() + $receiver.getHeadingRadians()));
        double enemyAdvancingVelocity = event.getVelocity() * (double)-1 * Math.cos(event.getHeadingRadians() - (event.getBearingRadians() + $receiver.getHeadingRadians()));
        double enemyDirection = AdvancedRobotExtensionsKt.calculateEnemyDirection($receiver.getHeadingRadians(), event);
        Iterable iterable = myBullets;
        BodyState bodyState = new BodyState($receiver.getWidth(), new Point2D.Double($receiver.getX(), $receiver.getY()), $receiver.getHeading(), $receiver.getHeadingRadians(), $receiver.getEnergy(), $receiver.getDistanceRemaining());
        GunState gunState = new GunState($receiver.getGunHeat());
        RadarState radarState = new RadarState();
        SelfState selfState2 = selfState;
        SelfState selfState3 = selfState;
        WorldState worldState = new WorldState($receiver.getBattleFieldWidth(), $receiver.getBattleFieldHeight(), $receiver.getTime());
        InstantState instantState2 = instantState;
        InstantState instantState3 = instantState;
        void var19_20 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            Bullet bullet = (Bullet)item$iv$iv;
            collection = destination$iv$iv;
            MyBullet myBullet = new MyBullet(new Point2D.Double(it.getX(), it.getY()), it.getHeadingRadians());
            collection.add(myBullet);
        }
        collection = (List)destination$iv$iv;
        selfState2(radarState, gunState, bodyState, CollectionsKt.toList((Iterable)collection));
        instantState2(worldState, selfState3, new EnemyState(event.getEnergy(), event.getHeading(), event.getHeadingRadians(), event.getBearing(), event.getBearingRadians(), event.getDistance(), event.getVelocity(), enemyDirection, enemyPosition, enemyLateralVelocity, enemyAdvancingVelocity, enemyNormalPositionX, enemyNormalPositionY, enemyNormalDistanceFromCenter, enemyNormalDistanceFromWall));
        return instantState3;
    }

    @NotNull
    public static final Pair<Double, Double> getEnemyRelativePosition(@NotNull AdvancedRobot $receiver, @NotNull ScannedRobotEvent event) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(event, "event");
        double absoluteBearing = Math.toRadians($receiver.getHeading() + event.getBearing());
        double relativeX = event.getDistance() * Math.sin(absoluteBearing);
        double relativeY = event.getDistance() * Math.cos(absoluteBearing);
        return new Pair<Double, Double>(relativeX, relativeY);
    }

    @NotNull
    public static final Point2D getEnemyAbsolutePosition(@NotNull AdvancedRobot $receiver, @NotNull ScannedRobotEvent event) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(event, "event");
        Pair<Double, Double> relativePosition = AdvancedRobotExtensionsKt.getEnemyRelativePosition($receiver, event);
        return new Point2D.Double($receiver.getX() + ((Number)relativePosition.getFirst()).doubleValue(), $receiver.getY() + ((Number)relativePosition.getSecond()).doubleValue());
    }

    public static final double calculateEnemyDirection(double headingRadians, @NotNull ScannedRobotEvent event) {
        Intrinsics.checkParameterIsNotNull(event, "event");
        double absBearingRadians = headingRadians + event.getBearingRadians();
        return event.getVelocity() != 0.0 ? (Math.sin(event.getHeadingRadians() - absBearingRadians) * event.getVelocity() < 0.0 ? -1.0 : 1.0) : 1.0;
    }

    private static final double calculateNormalDistanceFromWall(double normalX, double normalY) {
        return Math.min(Math.abs(normalX) - 1.0, Math.abs(normalY));
    }
}

