/*
 * Decompiled with CFR 0.152.
 */
package scheronimus;

import java.awt.geom.Point2D;
import robocode.AdvancedRobot;
import robocode.BulletHitEvent;
import robocode.BulletMissedEvent;
import robocode.HitByBulletEvent;
import robocode.HitWallEvent;
import robocode.Rules;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;

public class ScheroBot
extends AdvancedRobot {
    private byte moveDirection = 1;
    private int bulletHit = 0;
    private int bulletMissed = 0;
    private int hitByBullet = 0;
    private double distance;
    private double puissanceTir = 1.0;
    static double lastEnemyHeading;

    public void run() {
        this.setTurnRadarLeft(360.0);
        while (true) {
            this.scan();
        }
    }

    public double getAccuracy() {
        if (this.bulletHit + this.bulletMissed == 0) {
            return 0.0;
        }
        return this.bulletHit / (this.bulletHit + this.bulletMissed);
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        double dy;
        double dx;
        double bulletPower = this.setFireAccordingStats();
        double absBearingToEnemy = e.getBearingRadians() + this.getHeadingRadians();
        double gunHeading = this.getRadarHeadingRadians();
        double radarTurn = Utils.normalRelativeAngle((double)(absBearingToEnemy - gunHeading));
        double w = e.getHeadingRadians() - lastEnemyHeading;
        lastEnemyHeading = e.getHeadingRadians();
        double absbearing = e.getBearingRadians() + this.getHeadingRadians();
        double eX = e.getDistance() * Math.sin(absbearing);
        double eY = e.getDistance() * Math.cos(absbearing);
        double db = 0.0;
        double ww = lastEnemyHeading;
        do {
            dx = e.getVelocity() * Math.sin(ww);
            dy = e.getVelocity() * Math.cos(ww);
            ww += w;
        } while ((db += Rules.getBulletSpeed((double)bulletPower)) < Point2D.distance(0.0, 0.0, eX += dx, eY += dy));
        double gunTurn = Math.asin(Math.sin(Math.atan2(eX, eY) - this.getGunHeadingRadians()));
        this.setTurnRadarRightRadians(radarTurn);
        this.setAdjustRadarForGunTurn(true);
        this.setTurnGunRightRadians(gunTurn);
        if (this.getEnergy() > 3.0) {
            this.setFire(bulletPower);
        } else if (this.getEnergy() > 0.1) {
            this.setFire(0.1);
        }
        this.setAdjustGunForRobotTurn(true);
        this.doMove(e.getBearing());
    }

    public double setFireAccordingStats() {
        if (this.getAccuracy() > 0.7) {
            return 3.0;
        }
        if (this.getEnergy() > 60.0 || this.getEnergy() < 90.0) {
            return 2.0;
        }
        return 3.0;
    }

    public void doMove(double enemyBaring) {
        this.setTurnRight(enemyBaring + 90.0 - (double)(10 * this.moveDirection));
        if (this.getTime() % 20L == 0L) {
            this.moveDirection = (byte)(this.moveDirection * -1);
            this.setAhead(300 * this.moveDirection);
        }
    }

    public void onHitByBullet(HitByBulletEvent event) {
        ++this.hitByBullet;
    }

    public void onBulletHit(BulletHitEvent event) {
        ++this.bulletHit;
    }

    public void onBulletMissed(BulletMissedEvent event) {
        ++this.bulletMissed;
    }

    public void onHitWall(HitWallEvent event) {
    }
}

