/*
 * Decompiled with CFR 0.152.
 */
package wcsv.Stampede2;

import wcsv.Stampede2.target;

public class SegmentData {
    public static final double MAXDIST = 1000.0;
    public static final double MAXVELOCITY = 8.0;
    public static final int MAXTIME = 50;
    public int DistanceSegs;
    public int AccelSegs;
    public int LateralSegs;
    public int AdvancingSegs;
    public int WallSegs;
    public double[][][][][][] buffer;
    public int DistanceIndex;
    public int AccelIndex;
    public int LateralIndex;
    public int AdvancingIndex;
    public int WallIndex;

    public void setIndexData(target t, double waveVelocity) {
        this.DistanceIndex = (int)Math.min((double)(this.DistanceSegs - 1), Math.max(0.0, t.data.getDistance() / waveVelocity / (double)(50 / this.DistanceSegs)));
        this.AccelIndex = Math.min(this.AccelSegs - 1, this.getAccelIndex(t));
        this.LateralIndex = (int)Math.min((double)(this.LateralSegs - 1), ((double)Math.round(t.latVelocity) + 8.0) / (16.0 / (double)this.LateralSegs));
        this.AdvancingIndex = (int)Math.min((double)(this.AdvancingSegs - 1), ((double)Math.round(t.advVelocity) + 8.0) / (16.0 / (double)this.AdvancingSegs));
        this.WallIndex = Math.min(this.WallSegs - 1, this.getWallIndex(t));
    }

    public static int signIndex(double d) {
        if ((d = (double)Math.round(d)) < 0.0) {
            return 0;
        }
        if (d > 0.0) {
            return 2;
        }
        return 1;
    }

    public int getWallIndex(target t) {
        double ny;
        boolean rOut = false;
        boolean fOut = false;
        double nx = target.calcX(t.x, t.data.getHeading(), 130.0);
        if (SegmentData.outsideWall(nx, ny = target.calcY(t.y, t.data.getHeading(), 130.0))) {
            fOut = true;
        }
        if (SegmentData.outsideWall(nx = target.calcX(t.x, t.data.getHeading(), -130.0), ny = target.calcY(t.y, t.data.getHeading(), -130.0))) {
            rOut = true;
        }
        if (!fOut && !rOut) {
            return 0;
        }
        if (fOut && rOut) {
            return 1;
        }
        if (fOut) {
            return 2;
        }
        return 3;
    }

    public static boolean outsideWall(double x, double y) {
        boolean bl = false;
        if (x < 0.0 || y < 0.0 || y > 600.0 || x > 800.0) {
            bl = true;
        }
        return bl;
    }

    public double getRelativeHeading(target t) {
        return target.normalAbsoluteAngle(t.bearing + t.data.getHeading());
    }

    public int getAccelIndex(target t) {
        double a = t.calcLateralAcceleration();
        if (a < 0.0) {
            return 0;
        }
        if (a > 0.0) {
            return 2;
        }
        return 1;
    }

    public SegmentData(int d, int ac, int la, int a, int w, int factors) {
        this.DistanceSegs = d;
        this.AccelSegs = ac;
        this.LateralSegs = la;
        this.AdvancingSegs = a;
        this.WallSegs = w;
        this.buffer = new double[d][ac][la][a][w][factors];
    }
}

