/*
 * Decompiled with CFR 0.152.
 */
package wcsv.Stampede2;

import robocode.ScannedRobotEvent;

public class target {
    public ScannedRobotEvent data;
    public ScannedRobotEvent oldData;
    public double bearing;
    public double x;
    public double y;
    public double latVelocity;
    public double advVelocity;

    public target cloneTarget() {
        target temp = new target();
        temp.data = this.data;
        temp.oldData = this.oldData;
        temp.x = this.x;
        temp.y = this.y;
        temp.bearing = this.bearing;
        temp.latVelocity = this.latVelocity;
        temp.advVelocity = this.advVelocity;
        return temp;
    }

    public void refresh(ScannedRobotEvent e, double h0, double x0, double y0) {
        this.oldData = this.data;
        this.data = e;
        this.bearing = (h0 + e.getBearing()) % 360.0;
        this.x = target.calcX(x0, this.bearing, e.getDistance());
        this.y = target.calcY(y0, this.bearing, e.getDistance());
        this.latVelocity = this.lateralVelocity(e.getVelocity());
        this.advVelocity = this.advancingVelocity(e.getVelocity());
    }

    public static int sign(double d) {
        if ((d = (double)Math.round(d)) < 0.0) {
            return -1;
        }
        if (d > 0.0) {
            return 1;
        }
        return 0;
    }

    public static double calcX(double x1, double bearing, double distance) {
        return x1 + Math.sin(Math.toRadians(bearing)) * distance;
    }

    public static double calcY(double y1, double bearing, double distance) {
        return y1 + Math.cos(Math.toRadians(bearing)) * distance;
    }

    public static double calcDistance(double x1, double y1, double x2, double y2) {
        return Math.sqrt((x2 - x1) * (x2 - x1) + (y2 - y1) * (y2 - y1));
    }

    public double calcTime(double firePower) {
        return this.data.getDistance() / (20.0 - (double)3 * firePower);
    }

    public double calcTime(double firePower, double x, double y, double nx, double ny) {
        return target.calcDistance(x, y, nx, ny) / (20.0 - (double)3 * firePower);
    }

    public static double normalRelativeAngle(double angle) {
        if (angle > -180.0 && angle <= 180.0) {
            return angle;
        }
        double fixedAngle = angle;
        while (fixedAngle <= -180.0) {
            fixedAngle += 360.0;
        }
        while (fixedAngle > 180.0) {
            fixedAngle -= 360.0;
        }
        return fixedAngle;
    }

    public static double normalAbsoluteAngle(double angle) {
        if (angle >= 0.0 && angle < 360.0) {
            return angle;
        }
        double fixedAngle = angle;
        while (fixedAngle < 0.0) {
            fixedAngle += 360.0;
        }
        while (fixedAngle >= 360.0) {
            fixedAngle -= 360.0;
        }
        return fixedAngle;
    }

    public static double absbearing(double x1, double y1, double x2, double y2) {
        double xo = x2 - x1;
        double yo = y2 - y1;
        double h = Math.sqrt(xo * xo + yo * yo);
        if (xo > 0.0 && yo > 0.0) {
            return Math.toDegrees(Math.asin(xo / h));
        }
        if (xo > 0.0 && yo < 0.0) {
            return Math.toDegrees(Math.PI - Math.asin(xo / h));
        }
        if (xo < 0.0 && yo < 0.0) {
            return Math.toDegrees(Math.PI + Math.asin(-xo / h));
        }
        if (xo < 0.0 && yo > 0.0) {
            return Math.toDegrees(Math.PI * 2 - Math.asin(-xo / h));
        }
        return 0.0;
    }

    static double rollingAvg(double value, double newEntry, double n) {
        return (value * n + newEntry) / (n + 1.0);
    }

    public double lateralVelocity(double s) {
        return s * Math.sin(Math.toRadians(this.data.getHeading()) - Math.toRadians(this.bearing));
    }

    public double advancingVelocity(double s) {
        return -Math.cos(Math.toRadians(this.data.getHeading()) - Math.toRadians(this.bearing)) * s;
    }

    public double calcAcceleration() {
        if (this.data.getTime() - this.oldData.getTime() == 0L) {
            return 0.0;
        }
        return (this.data.getVelocity() - this.oldData.getVelocity()) / (double)(this.data.getTime() - this.oldData.getTime());
    }

    public double calcLateralAcceleration() {
        if (this.data.getTime() - this.oldData.getTime() == 0L) {
            return 0.0;
        }
        return (this.latVelocity - this.lateralVelocity(this.oldData.getVelocity())) / (double)(this.data.getTime() - this.oldData.getTime());
    }

    public target() {
    }

    public target(ScannedRobotEvent e, double h0, double x0, double y0) {
        this.oldData = e;
        this.data = e;
        this.bearing = (h0 + e.getBearing()) % 360.0;
        this.x = target.calcX(x0, this.bearing, e.getDistance());
        this.y = target.calcY(y0, this.bearing, e.getDistance());
        this.latVelocity = this.lateralVelocity(e.getVelocity());
        this.advVelocity = this.advancingVelocity(e.getVelocity());
    }
}

