/*
 * Decompiled with CFR 0.152.
 */
package com.spp.robocode.targeting;

import com.spp.robocode.BattlefieldModel;
import com.spp.robocode.Enemy;
import com.spp.robocode.targeting.TargetModel;
import robocode.AdvancedRobot;
import robocode.Rules;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;

public class LinearTargeting
implements TargetModel {
    @Override
    public double getFiringSolution(Enemy enemy, double power, AdvancedRobot robot, double robotHeading) {
        double c;
        double a;
        double D;
        double C;
        double eHd;
        double retVal = 0.0;
        double ROBOT_WIDTH = 16.0;
        double ROBOT_HEIGHT = 16.0;
        double eAbsBearing = robotHeading + enemy.getBearingRadians();
        double rX = robot.getX();
        double rY = robot.getY();
        double bV = Rules.getBulletSpeed((double)power);
        double eX = rX + (double)enemy.getDistance() * Math.sin(eAbsBearing);
        double eY = rY + (double)enemy.getDistance() * Math.cos(eAbsBearing);
        double A = (eX - rX) / bV;
        double eV = enemy.getVelocity();
        double B = eV / bV * Math.sin(eHd = enemy.getHeadingRadians());
        double b = 2.0 * (A * B + (C = (eY - rY) / bV) * (D = eV / bV * Math.cos(eHd)));
        double discrim = b * b - 4.0 * (a = A * A + C * C) * (c = B * B + D * D - 1.0);
        if (discrim >= 0.0) {
            double t2;
            double t1 = 2.0 * a / (-b - Math.sqrt(discrim));
            double t = Math.min(t1, t2 = 2.0 * a / (-b + Math.sqrt(discrim))) >= 0.0 ? Math.min(t1, t2) : Math.max(t1, t2);
            double endX = this.limit(eX + eV * t * Math.sin(eHd), 8.0, robot.getBattleFieldWidth() - 8.0);
            double endY = this.limit(eY + eV * t * Math.cos(eHd), 8.0, robot.getBattleFieldHeight() - 8.0);
            retVal = Utils.normalRelativeAngle((double)(Math.atan2(endX - rX, endY - rY) - robot.getGunHeadingRadians()));
        }
        return retVal;
    }

    private double limit(double value, double min, double max) {
        return Math.min(max, Math.max(min, value));
    }

    public double getFiringSolutionOld(Enemy enemy, double power, AdvancedRobot robot, double robotHeading) {
        double speed = 20.0 - 3.0 * power - 1.0;
        double absBearing = robotHeading + enemy.getBearingRadians();
        double angle = enemy.getVelocity() * Math.sin(enemy.getHeadingRadians() - absBearing) / speed;
        double time = (double)enemy.getDistance() / speed;
        System.out.println("ABS: " + absBearing * 180.0 / Math.PI);
        System.out.println("Fire: " + angle * 180.0 / Math.PI);
        double x = (double)enemy.getDistance() * Math.sin(absBearing + angle) + robot.getX();
        double y = (double)enemy.getDistance() * Math.cos(absBearing + angle) + robot.getY();
        if (x > 1000.0) {
            x = 1000.0;
        }
        if (x < 0.0) {
            x = 0.0;
        }
        if (y > 1000.0) {
            y = 1000.0;
        }
        if (y < 0.0) {
            y = 0.0;
        }
        System.out.println("Predict: " + x + "," + y);
        System.out.println("Mine: " + robot.getX() + "," + robot.getY());
        System.out.println("Diff: " + (x - robot.getX()) + "," + (y - robot.getY()));
        System.out.println("A1=" + angle * 180.0 / Math.PI);
        double a = Math.atan((y - robot.getY()) / (x - robot.getX()));
        System.out.println("A: " + a * 180.0 / Math.PI);
        System.out.println("E: " + enemy.getBearingRadians() * 180.0 / Math.PI);
        System.out.println("Abs: " + absBearing * 180.0 / Math.PI);
        System.out.println("Rob: " + robotHeading * 180.0 / Math.PI);
        angle = Math.abs(absBearing + a - 1.5707963267948966);
        System.out.println("A2=" + angle * 180.0 / Math.PI);
        double gunAdjust = Utils.normalRelativeAngle((double)(absBearing + angle - robot.getGunHeadingRadians()));
        return gunAdjust;
    }

    @Override
    public void onScannedRobot(AdvancedRobot robot, ScannedRobotEvent event, BattlefieldModel model) {
    }

    @Override
    public String getName() {
        return "LINEAR";
    }
}

