/*
 * Decompiled with CFR 0.152.
 */
package KiraNL;

import java.awt.Color;
import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.Random;
import robocode.AdvancedRobot;
import robocode.BulletHitEvent;
import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;

public class ChupaLite
extends AdvancedRobot {
    private ArrayList<Airborn> bullets = new ArrayList();
    private double enemyLife = 100.0;
    static StringBuffer pattern = new StringBuffer("\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\ufff8\ufff9\ufffa\ufffb\ufffc\ufffd\ufffe\uffff\u0001\u0002\u0003\u0004\u0005\u0006\u0007\b");
    static StringBuilder sb = new StringBuilder();

    public void run() {
        this.setAdjustGunForRobotTurn(true);
        this.setAdjustRadarForGunTurn(true);
        this.setAdjustRadarForRobotTurn(true);
        this.turnRadarRightRadians(Double.POSITIVE_INFINITY);
        while (true) {
            this.scan();
            this.execute();
        }
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        double d;
        double eDistance = e.getDistance();
        double eAbsBearing = e.getBearingRadians() + this.getHeadingRadians();
        double eX = this.getX() + Math.sin(eAbsBearing) * eDistance;
        double eY = this.getY() + Math.cos(eAbsBearing) * eDistance;
        double radarTurn = eAbsBearing - this.getRadarHeadingRadians();
        this.setTurnRadarRightRadians(Utils.normalRelativeAngle((double)radarTurn));
        this.enemyLife = e.getEnergy();
        double firePower = this.enemyLife - this.enemyLife;
        if (d > 0.0 && firePower <= 3.0) {
            double bVel = 20.0 - 3.0 * firePower;
            double bAngle = Utils.normalRelativeAngle((double)(eAbsBearing + Math.PI + Math.asin(Math.sin(e.getBearingRadians()) * this.getVelocity() / bVel)));
            this.bullets.add(new Airborn(eX, eY, bVel, bAngle));
        }
        int i = 0;
        while (i < this.bullets.size()) {
            this.bullets.get(i).update();
            if (!this.bullets.get(i).isAirborn(this.getX(), this.getY())) {
                this.bullets.remove(i);
                --i;
            }
            ++i;
        }
        double absbearing = e.getBearingRadians();
        this.setTurnRightRadians(absbearing - 1.5707963267948966);
        pattern.insert(0, (char)Math.round(Math.sin(e.getHeadingRadians() - (absbearing += this.getHeadingRadians())) * e.getVelocity()));
        int index = 0;
        int searchlength = 30;
        while ((index = pattern.toString().indexOf(pattern.substring(0, searchlength--), 1)) < 0) {
        }
        double bPower = this.limit(400.0 / eDistance, 2.0, 3.0);
        double bVelocity = 20.0 - 3.0 * bPower;
        searchlength = index - (int)(eDistance / bVelocity);
        do {
            absbearing += Math.asin((double)((byte)pattern.charAt(index--)) / eDistance);
        } while (index >= Math.max(0, searchlength));
        this.setTurnGunRightRadians(Utils.normalRelativeAngle((double)(absbearing - this.getGunHeadingRadians())));
        this.setFire(bPower);
        double xForce = 0.0;
        double yForce = 0.0;
        int i2 = 0;
        while (i2 < this.bullets.size()) {
            double bAbsBearing = Utils.normalAbsoluteAngle((double)Math.atan2(this.bullets.get(i2).getX() - this.getX(), this.bullets.get(i2).getY() - this.getY()));
            double distance = this.getDistance(this.bullets.get(i2).getX(), this.bullets.get(i2).getY(), this.getX(), this.getY());
            xForce += Math.sin(bAbsBearing) / (distance * distance);
            yForce += Math.cos(bAbsBearing) / (distance * distance);
            ++i2;
        }
        xForce += Math.sin(eAbsBearing) / (eDistance * eDistance);
        yForce += Math.cos(eAbsBearing) / (eDistance * eDistance);
        xForce += 250.0 / Math.pow(this.getDistance(this.getX(), this.getY(), this.getBattleFieldWidth(), this.getY()), 3.0);
        yForce += 250.0 / Math.pow(this.getDistance(this.getX(), this.getY(), this.getX(), this.getBattleFieldHeight()), 3.0);
        this.goTo(this.getX() - (xForce -= 250.0 / Math.pow(this.getDistance(this.getX(), this.getY(), 0.0, this.getY()), 3.0)), this.getY() - (yForce -= 250.0 / Math.pow(this.getDistance(this.getX(), this.getY(), this.getX(), 0.0), 3.0)));
    }

    public void onHitByBullet(HitByBulletEvent e) {
        this.enemyLife += 3.0 * e.getBullet().getPower();
    }

    public void onBulletHit(BulletHitEvent e) {
        this.enemyLife -= 4.0 * e.getBullet().getPower() + Math.max(0.0, 2.0 * (e.getBullet().getPower() - 1.0));
    }

    public void onHitRobot(HitRobotEvent e) {
        this.enemyLife -= 0.6;
    }

    public void onPaint(Graphics2D g) {
        g.setColor(new Color(0, 255, 0));
        int i = 0;
        while (i < this.bullets.size()) {
            g.fillOval((int)this.bullets.get(i).getX() - 3, (int)this.bullets.get(i).getY() - 3, 6, 6);
            ++i;
        }
    }

    private void goTo(double x, double y) {
        double dir;
        double dist = new Random().nextInt(7) + 8;
        double angle = this.normaliseBearing(this.getHeading() - Math.toDegrees(this.absbearing(this.getX(), this.getY(), x, y)));
        if (angle > 90.0) {
            angle -= 180.0;
            dir = -1.0;
        } else if (angle < -90.0) {
            angle += 180.0;
            dir = -1.0;
        } else {
            dir = 1.0;
        }
        this.setTurnLeft(angle);
        this.setAhead(dist * dir);
    }

    private double normaliseBearing(double ang) {
        if (ang > Math.PI) {
            ang -= Math.PI * 2;
        }
        if (ang < -Math.PI) {
            ang += Math.PI * 2;
        }
        return ang;
    }

    private double absbearing(double x1, double y1, double x2, double y2) {
        double xo = x2 - x1;
        double yo = y2 - y1;
        double h = this.getDistance(x1, y1, x2, y2);
        if (xo > 0.0 && yo > 0.0) {
            return Math.asin(xo / h);
        }
        if (xo > 0.0 && yo < 0.0) {
            return Math.PI - Math.asin(xo / h);
        }
        if (xo < 0.0 && yo < 0.0) {
            return Math.PI + Math.asin(-xo / h);
        }
        if (xo < 0.0 && yo > 0.0) {
            return Math.PI * 2 - Math.asin(-xo / h);
        }
        return 0.0;
    }

    private double getDistance(double x1, double y1, double x2, double y2) {
        return Math.sqrt(Math.pow(x1 - x2, 2.0) + Math.pow(y1 - y2, 2.0));
    }

    private double limit(double value, double min, double max) {
        return Math.min(max, Math.max(min, value));
    }

    public class Airborn {
        private double x;
        private double y;
        private double speed;
        private double angle;
        private double shotTime;

        public Airborn(double bX, double bY, double bVel, double bAngle) {
            this.x = bX;
            this.y = bY;
            this.speed = bVel;
            this.angle = bAngle;
            this.shotTime = ChupaLite.this.getTime() - 1L;
        }

        public void update() {
            double ticks = (double)ChupaLite.this.getTime() - this.shotTime;
            this.x += ticks * Math.sin(this.angle) * this.speed;
            this.y += ticks * Math.cos(this.angle) * this.speed;
            this.shotTime = ChupaLite.this.getTime();
        }

        public double getX() {
            return this.x;
        }

        public double getY() {
            return this.y;
        }

        public boolean isAirborn(double botX, double botY) {
            if (this.x < 0.0 || this.y < 0.0 || this.x > ChupaLite.this.getBattleFieldWidth() || this.y > ChupaLite.this.getBattleFieldHeight()) {
                return false;
            }
            return !(botX - 18.0 < this.x) || !(botX + 18.0 > this.x) || !(botY - 18.0 < this.y) || !(botY + 18.0 > this.y);
        }
    }
}

