/*
 * Decompiled with CFR 0.152.
 */
package rdt.AgentSmith.Guns;

import rdt.AgentSmith.IRobot;
import rdt.AgentSmith.IRoundStartedEventHandler;
import rdt.AgentSmith.ISubsystemMode;
import rdt.AgentSmith.Targeting.ITargeting;
import rdt.AgentSmith.Targeting.Target;
import rdt.AgentSmith.Waves.IWaveManager;
import rdt.AgentSmith.Waves.WaveData;
import robocode.Rules;
import robocode.util.Utils;

public class ClosestTargetMode
implements ISubsystemMode,
IRoundStartedEventHandler {
    private final IRobot _robot;
    private final ITargeting _targeting;
    private final IWaveManager _friendlyWaveManager;
    private double _nextFirePower;
    private long _nextFireTurn;
    private final double[] _bulletAngle = new double[1];

    public ClosestTargetMode(IRobot robot, ITargeting targeting, IWaveManager friendlyWaveManager) {
        this._robot = robot;
        this._targeting = targeting;
        this._friendlyWaveManager = friendlyWaveManager;
        this._robot.RegisterForEventHandling(this);
    }

    @Override
    public void UpdateHighestPriority() {
        if (!this._targeting.HasValidTarget()) {
            return;
        }
        Target target = this._targeting.GetCurrentTarget();
        if (!target.Alive) {
            return;
        }
        if (this._robot.getEnergy() <= 0.0) {
            return;
        }
        if (target.RobotHistory.SnapshotCount <= 3) {
            return;
        }
        if (this._robot.GetRobotHistory().SnapshotCount <= 3) {
            return;
        }
        this._nextFirePower = 1.7;
        if (this._nextFirePower <= 0.0) {
            return;
        }
        if (this._nextFireTurn == this._robot.getTime() && this._robot.getGunTurnRemaining() == 0.0 && this._robot.getGunHeat() <= 0.0) {
            this._friendlyWaveManager.FireWave(this._robot.getX(), this._robot.getY(), WaveData.eWaveType.Real, this._nextFirePower, this._robot.getTime(), null);
            this._robot.setFire(this._nextFirePower);
            return;
        }
        if (target.RobotHistory.GetSnapshotForTick(this._robot.getTime()) == null) {
            return;
        }
        if (target.RobotHistory.GetSnapshotForTick(this._robot.getTime() - 1L) == null) {
            return;
        }
        double bulletVelocity = Rules.getBulletSpeed((double)this._nextFirePower);
        target.GunsFiredAtTarget.PredictAngles(this._robot.NextX(), this._robot.NextY(), this._robot.getTime(), bulletVelocity, this._bulletAngle);
        this._robot.setTurnGunRightRadians(Utils.normalRelativeAngle((double)(this._bulletAngle[0] - this._robot.getGunHeadingRadians())));
        this._nextFireTurn = this._robot.getTime() + 1L;
    }

    @Override
    public float GetPriority() {
        if (!this._targeting.HasValidTarget()) {
            return 0.0f;
        }
        Target target = this._targeting.GetCurrentTarget();
        if (!target.Alive) {
            return 0.0f;
        }
        if (this._robot.getEnergy() <= 0.0) {
            return 0.0f;
        }
        if (target.RobotHistory.SnapshotCount <= 3) {
            return 0.0f;
        }
        if (this._robot.GetRobotHistory().SnapshotCount <= 3) {
            return 0.0f;
        }
        return 1.0f;
    }

    @Override
    public void Update() {
    }

    @Override
    public void OnRoundStartedEvent() {
        this._nextFireTurn = -1L;
    }
}

