/*
 * Decompiled with CFR 0.152.
 */
package rjw.gun;

import java.awt.geom.Point2D;
import rjw.gun.GunData;
import rjw.pluggablerobot.Math2;
import rjw.util.Wave;

public class GunWave
extends Wave
implements Comparable<GunWave> {
    private GunData[] _gunData;
    private Double _correctAngle = null;

    public GunWave(String targetName, Point2D.Double origin, long fireTime, GunData[] gunData, double power) {
        this._origin = origin;
        this._fireTime = fireTime;
        this._gunData = gunData;
        this._energy = power;
    }

    public GunData getGunData(int index) {
        return this._gunData[index];
    }

    public Double getCorrectAngle() {
        return this._correctAngle;
    }

    public Point2D.Double getBulletPosition(int index, long tick) {
        Double angle = this._gunData[index].getFireAngle();
        if (angle == null) {
            return null;
        }
        return Math2.getAbsolutePosition(this._origin, angle, this.radius(tick));
    }

    public void setCorrectAngle(double correctAngle) {
        this._correctAngle = correctAngle;
    }

    @Override
    public int compareTo(GunWave o) {
        return this._fireTime == o.getFireTime() ? 0 : (this._fireTime < o.getFireTime() ? -1 : 1);
    }
}

