/*
 * Decompiled with CFR 0.152.
 */
package ds.gun.hot;

import ds.Hud;
import ds.gun.AbstractGun;
import ds.gun.FireSolution;
import ds.targeting.ITargetManager;
import ds.targeting.IVirtualBot;
import ds.targeting.TargetException;
import java.awt.Color;
import robocode.AdvancedRobot;
import robocode.util.Utils;

public class HoTGun
extends AbstractGun {
    public HoTGun(AdvancedRobot owner, ITargetManager targetManager) {
        super("hot", owner, targetManager, Color.blue);
    }

    @Override
    protected FireSolution computeFireSolution(double bulletPower) {
        try {
            IVirtualBot target = this.getTargetManager().getCurrentTarget();
            double absoluteBearing = this.getOwner().getHeadingRadians() + target.getBearingRadians();
            double angle = Utils.normalRelativeAngle((double)(absoluteBearing - this.getOwner().getGunHeadingRadians()));
            double absoluteAngle = Utils.normalRelativeAngle((double)absoluteBearing);
            return new FireSolution(angle, absoluteAngle, 1.0);
        }
        catch (TargetException te) {
            return new FireSolution(0.0, 0.0, 0.0);
        }
    }

    @Override
    public void paint(Hud hud, long tick) {
    }
}

