/*
 * Decompiled with CFR 0.152.
 */
package kid.movement.radar;

import java.awt.geom.Point2D;
import kid.info.RadarInfo;
import kid.robot.RobotData;
import kid.utils.Utils;
import robocode.AdvancedRobot;
import robocode.Robot;

public class RadarMovement {
    private Robot robot;
    private AdvancedRobot advancedRobot;
    public RadarInfo info;

    public RadarMovement(Robot myRobot) {
        this.init(myRobot);
    }

    private void init(Robot myRobot) {
        this.robot = myRobot;
        if (myRobot instanceof AdvancedRobot) {
            this.advancedRobot = (AdvancedRobot)myRobot;
        }
        this.info = new RadarInfo(myRobot);
    }

    public void move(RobotData[] robots) {
    }

    public void right(double a) {
        this.robot.turnRadarRight(a);
    }

    public void setRight(double a) {
        if (this.advancedRobot != null) {
            this.advancedRobot.setTurnRadarRight(a);
        }
    }

    public void left(double a) {
        this.robot.turnRadarLeft(a);
    }

    public void setLeft(double a) {
        if (this.advancedRobot != null) {
            this.advancedRobot.setTurnRadarLeft(a);
        }
    }

    public final void turnTo(double angle) {
        double theta = this.info.bearing(angle);
        this.right(theta);
    }

    public final void setTurnTo(double angle) {
        double theta = this.info.bearing(angle);
        this.setRight(theta);
    }

    public final void sweep(double angle, double sweep) {
        double theta = this.info.bearing(angle);
        theta += (double)Utils.sign(theta) * Math.abs(sweep);
        this.right(theta);
    }

    public final void setSweep(double angle, double sweep) {
        double theta = this.info.bearing(angle);
        theta += (double)Utils.sign(theta) * Math.abs(sweep);
        this.setRight(theta);
    }

    public final void turnTo(double x, double y) {
        double theta = this.info.bearing(x, y);
        this.right(theta);
    }

    public final void setTurnTo(double x, double y) {
        double theta = this.info.bearing(x, y);
        this.setRight(theta);
    }

    public final void sweep(double x, double y, double sweep) {
        double theta = this.info.bearing(x, y);
        theta += (double)Utils.sign(theta) * Math.abs(sweep);
        this.right(theta);
    }

    public final void setSweep(double x, double y, double sweep) {
        double theta = this.info.bearing(x, y);
        theta += (double)Utils.sign(theta) * Math.abs(sweep);
        this.setRight(theta);
    }

    public final void turnTo(Point2D point) {
        double theta = this.info.bearing(point);
        this.right(theta);
    }

    public final void setTurnTo(Point2D point) {
        double theta = this.info.bearing(point);
        this.setRight(theta);
    }

    public final void sweep(Point2D point, double sweep) {
        double theta = this.info.bearing(point);
        theta += (double)Utils.sign(theta) * Math.abs(sweep);
        this.right(theta);
    }

    public final void setSweep(Point2D point, double sweep) {
        double theta = this.info.bearing(point);
        theta += (double)Utils.sign(theta) * Math.abs(sweep);
        this.setRight(theta);
    }

    public final void turnTo(RobotData robot) {
        double theta = this.info.bearing(robot);
        this.right(theta);
    }

    public final void setTurnTo(RobotData robot) {
        double theta = this.info.bearing(robot);
        this.setRight(theta);
    }

    public final void sweep(RobotData robot, double sweep) {
        double theta = this.info.bearing(robot);
        theta += (double)Utils.sign(theta) * Math.abs(sweep);
        this.right(theta);
    }

    public final void setSweep(RobotData robot, double sweep) {
        double theta = this.info.bearing(robot);
        theta += (double)Utils.sign(theta) * Math.abs(sweep);
        this.setRight(theta);
    }
}

