/*
 * Decompiled with CFR 0.152.
 */
package catcat20.move;

import catcat20.bot.Bot;
import catcat20.bot.BotState;
import catcat20.bot.GunData;
import catcat20.move.KNNResultWithWave;
import catcat20.radar.Radar;
import catcat20.utils.LConstants;
import catcat20.utils.LUtils;
import catcat20.utils.MovementPredictor;
import catcat20.utils.PreciseWallSmooth;
import catcat20.utils.ShadowBullet;
import catcat20.utils.knn.GFData;
import catcat20.utils.knn.KNNData;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import robocode.Rules;
import robocode.util.Utils;
import voidious.utils.geom.Circle;
import voidious.utils.geom.LineSeg;

public class SurfWave
extends Point2D.Double {
    public ArrayList<BulletShadow> shadows = new ArrayList();
    public HashMap<ShadowBullet, Boolean> processedBullets = new HashMap();
    public final double bulletVelocity;
    public String sourceName;
    public double bulletPower;
    public long fireTime;
    public Point2D.Double myPos;
    public boolean doBranchWave = true;
    public boolean isMeleeWave = false;
    public boolean isMyWave = false;
    public boolean isRamWave = false;
    public boolean hasNeighbors = false;
    public ArrayList<KNNResultWithWave> allNearestNeighbors;
    public HashMap<String, WaveData> waveData;
    public ArrayList<WaveData> waveDataArrayList;
    PreciseWallSmooth.Trig trig = new PreciseWallSmooth.Trig();
    private Point2D.Double cache = new Point2D.Double();

    public SurfWave(double x, double y, String sourceName, double bulletPower, long fireTime) {
        super(x, y);
        this.sourceName = sourceName;
        this.bulletPower = bulletPower;
        this.fireTime = fireTime;
        this.bulletVelocity = Rules.getBulletSpeed((double)bulletPower);
        this.waveData = new HashMap();
        this.allNearestNeighbors = new ArrayList();
        this.waveDataArrayList = new ArrayList();
        for (Bot bot : Radar.enemies.values()) {
            if (bot.name.equals(sourceName) || !bot.isAlive || bot.states.size() <= 2) continue;
            BotState botStateLast2 = bot.states.get(2);
            GunData gunData = Radar.getBot((String)sourceName).shotDataMaps.get(2).get(bot.name);
            WaveData data = new WaveData();
            data.name = bot.name;
            data.directAngle = LUtils.absoluteBearing(x, y, botStateLast2.x, botStateLast2.y);
            data.targetState = botStateLast2.clone();
            data.targetGunData = gunData.clone();
            data.direction = LUtils.sign(data.targetGunData.youLatVel);
            data.meas = this.getMea(bulletPower, botStateLast2, x, y, 0L, data.direction);
            data.nearestNeighbors = new ArrayList();
            this.waveDataArrayList.add(data);
            this.waveData.put(bot.name, data);
        }
        if (Radar.myStates.size() > 2) {
            BotState botStateLast2 = Radar.myStates.get(2);
            GunData gunData = Radar.getBot((String)sourceName).shotDataMaps.get(2).get(Radar.myName);
            WaveData data = new WaveData();
            data.name = Radar.myName;
            data.directAngle = LUtils.absoluteBearing(x, y, botStateLast2.x, botStateLast2.y);
            data.targetState = botStateLast2.clone();
            data.targetGunData = gunData.clone();
            data.direction = LUtils.sign(data.targetGunData.youLatVel);
            data.meas = this.getMea(bulletPower, botStateLast2, x, y, 0L, data.direction);
            data.nearestNeighbors = new ArrayList();
            this.waveData.put(Radar.myName, data);
            this.waveDataArrayList.add(data);
        }
    }

    public double[] getMea(double power, BotState en, double myX, double myY, long time, int direction) {
        MovementPredictor.PredictionStatus status = new MovementPredictor.PredictionStatus(en.x, en.y, en.heading, en.velocity, time);
        double absBearing = LUtils.absoluteBearing(myX, myY, en.x, en.y);
        double distance = Point2D.Double.distance(myX, myY, en.x, en.y);
        double bft = distance / Rules.getBulletSpeed((double)power);
        int count = (int)bft;
        MovementPredictor.PredictionStatus dir1 = (MovementPredictor.PredictionStatus)status.clone();
        double distTravel1 = 0.0;
        for (int i = 0; i < count; ++i) {
            distTravel1 += Rules.getBulletSpeed((double)power);
            double dist1 = Point2D.Double.distance(myX, myY, dir1.x, dir1.y);
            if (!(dist1 - distTravel1 > 0.0)) break;
            double angle = LUtils.absoluteBearing(dir1.x, dir1.y, myX, myY) + 1.5707963267948966 * (double)direction;
            this.trig.sin = Math.sin(angle);
            this.trig.cos = Math.cos(angle);
            angle = LConstants.preciseWallSmooth.smoothHeading(angle, this.trig, dir1.x, dir1.y, -1 * direction);
            dir1 = MovementPredictor.predict(dir1, angle, 8.0);
        }
        double distTravel2 = 0.0;
        MovementPredictor.PredictionStatus dir2 = (MovementPredictor.PredictionStatus)status.clone();
        for (int i = 0; i < count; ++i) {
            distTravel2 += Rules.getBulletSpeed((double)power);
            double dist2 = Point2D.Double.distance(myX, myY, dir2.x, dir2.y);
            if (!(dist2 - distTravel2 > 0.0)) break;
            double angle = LUtils.absoluteBearing(dir2.x, dir2.y, myX, myY) - 1.5707963267948966 * (double)direction;
            this.trig.sin = Math.sin(angle);
            this.trig.cos = Math.cos(angle);
            angle = LConstants.preciseWallSmooth.smoothHeading(angle, this.trig, dir2.x, dir2.y, direction);
            dir2 = MovementPredictor.predict(dir2, angle, 8.0);
        }
        double mea1 = Utils.normalRelativeAngle((double)(LUtils.absoluteBearing(myX, myY, dir1.x, dir1.y) - absBearing));
        double mea2 = Utils.normalRelativeAngle((double)(LUtils.absoluteBearing(myX, myY, dir2.x, dir2.y) - absBearing));
        return new double[]{Math.abs(mea1), Math.abs(mea2)};
    }

    public double getDistanceTraveled(long time) {
        return this.bulletVelocity * (double)(time - this.fireTime);
    }

    public double firingAngle(WaveData data, double guessFactor) {
        return data.directAngle + guessFactor * (double)data.direction * this.maxEscapeAngle();
    }

    public double guessFactor(WaveData data, Point2D.Double targetLocation) {
        double bearingToTarget = LUtils.absoluteBearing(this, targetLocation);
        return this.guessFactor(data, bearingToTarget);
    }

    public double guessFactor(WaveData data, double bearingToTarget) {
        return this.guessAngle(data, bearingToTarget) / this.maxEscapeAngle();
    }

    public double guessAngle(WaveData data, Point2D.Double targetLocation) {
        double bearingToTarget = LUtils.absoluteBearing(this, targetLocation);
        return this.guessAngle(data, bearingToTarget);
    }

    public double guessAngle(WaveData data, double bearingToTarget) {
        return (double)data.direction * Utils.normalRelativeAngle((double)(bearingToTarget - data.directAngle));
    }

    public double maxEscapeAngle() {
        return Math.asin(8.0 / this.bulletVelocity);
    }

    void addBulletShadows(ShadowBullet b, long time) {
        Circle waveCircle1 = new Circle(new Point2D.Double(this.x, this.y), this.getDistanceTraveled(time - 1L));
        Circle waveCircle2 = new Circle(new Point2D.Double(this.x, this.y), this.getDistanceTraveled(time));
        Point2D.Double bulletPoint1 = b.simulatePos(time - 1L);
        Point2D.Double bulletPoint2 = b.simulatePos(time);
        LineSeg bulletSeg = new LineSeg(bulletPoint1, bulletPoint2);
        Point2D.Double[] xPoints1 = waveCircle1.intersects(bulletSeg);
        Point2D.Double[] xPoints2 = waveCircle2.intersects(bulletSeg);
        if (xPoints1[0] == null && xPoints2[0] == null) {
            this.castShadow(bulletPoint1, bulletPoint2);
        } else if (xPoints1[0] != null) {
            if (xPoints2[0] != null) {
                this.castShadow(xPoints2[0], xPoints1[0]);
            } else if (xPoints1[1] != null) {
                Point2D.Double intersect2;
                Point2D.Double intersect1;
                if (bulletPoint1.distanceSq(xPoints1[0]) < bulletPoint1.distanceSq(xPoints1[1])) {
                    intersect1 = xPoints1[0];
                    intersect2 = xPoints1[1];
                } else {
                    intersect1 = xPoints1[1];
                    intersect2 = xPoints1[0];
                }
                this.castShadow(bulletPoint1, intersect1);
                this.castShadow(intersect2, bulletPoint2);
            } else {
                this.castShadow(bulletPoint1, xPoints1[0]);
            }
        } else if (xPoints2[0] != null) {
            this.castShadow(xPoints2[0], bulletPoint2);
        }
    }

    public void castShadow(Point2D.Double p1, Point2D.Double p2) {
        this.cache.setLocation((p1.x + p2.x) / 2.0, (p1.y + p2.y) / 2.0);
        this.castShadow(LUtils.absoluteBearing(this.x, this.y, p1.x, p1.y), LUtils.absoluteBearing(this.x, this.y, p2.x, p2.y), LUtils.absoluteBearing(this.x, this.y, this.cache.x, this.cache.y));
    }

    private void castShadow(double shadowAngle1, double shadowAngle2, double directAngle) {
        shadowAngle1 = LUtils.normalizeAngle(shadowAngle1, directAngle);
        shadowAngle2 = LUtils.normalizeAngle(shadowAngle2, shadowAngle1);
        double min = Math.min(shadowAngle1, shadowAngle2);
        double max = Math.max(shadowAngle1, shadowAngle2);
        this.shadows.add(new BulletShadow(min, max));
        HashSet<BulletShadow> deadShadows = new HashSet<BulletShadow>();
        for (BulletShadow shadow1 : this.shadows) {
            if (deadShadows.contains(shadow1)) continue;
            for (BulletShadow shadow2 : this.shadows) {
                if (shadow1 == shadow2 || deadShadows.contains(shadow2) || !shadow1.overlaps(shadow2)) continue;
                shadow1.minAngle = Math.min(shadow1.minAngle, LUtils.normalizeAngle(shadow2.minAngle, shadow1.minAngle));
                shadow1.maxAngle = Math.max(shadow1.maxAngle, LUtils.normalizeAngle(shadow2.maxAngle, shadow1.maxAngle));
                deadShadows.add(shadow2);
            }
        }
        for (BulletShadow deadShadow : deadShadows) {
            this.shadows.remove(deadShadow);
        }
    }

    public boolean shadowed(double firingAngle) {
        for (BulletShadow shadow : this.shadows) {
            if (!((firingAngle = LUtils.normalizeAngle(firingAngle, shadow.minAngle)) >= shadow.minAngle) || !(firingAngle <= shadow.maxAngle)) continue;
            return true;
        }
        return false;
    }

    public double coveredWidthByShadow(double angle, double bandwidth) {
        double min = angle - bandwidth;
        double max = angle + bandwidth;
        double coveredRange = 0.0;
        for (BulletShadow shadow : this.shadows) {
            if (shadow.minAngle >= max || shadow.maxAngle <= min) continue;
            double minf = shadow.minAngle;
            double maxf = shadow.maxAngle;
            if (minf < min) {
                minf = min;
            }
            if (maxf > max) {
                maxf = max;
            }
            coveredRange += maxf - minf;
        }
        return coveredRange / (bandwidth * 2.0);
    }

    public static class WaveData {
        public String name;
        public BotState targetState;
        public GunData targetGunData;
        public double[] meas;
        public double directAngle;
        public int direction;
        ArrayList<KNNData<GFData>> nearestNeighbors;
    }

    public static class BulletShadow {
        public double minAngle;
        public double maxAngle;

        public BulletShadow(double minAngle, double maxAngle) {
            this.minAngle = minAngle;
            this.maxAngle = maxAngle;
        }

        public boolean overlaps(BulletShadow that) {
            double thatMinAngle = LUtils.normalizeAngle(that.minAngle, this.minAngle);
            double thatMaxAngle = LUtils.normalizeAngle(that.maxAngle, thatMinAngle);
            return this.overlaps(that.minAngle) || this.overlaps(that.maxAngle) || thatMinAngle <= this.minAngle && thatMaxAngle >= this.maxAngle;
        }

        private boolean overlaps(double angle) {
            return this.minAngle <= (angle = LUtils.normalizeAngle(angle, this.minAngle)) && this.maxAngle >= angle;
        }
    }
}

