/*
 * Decompiled with CFR 0.152.
 */
package synnalagma;

import java.awt.geom.Point2D;
import synnalagma.RobotBase;
import synnalagma.RobotMath;

public class Point
extends Point2D.Double
implements Cloneable {
    protected double force = 0.0;

    public Point(double d, double d2, double d3) {
        super(d, d2);
        this.force = d3;
    }

    public Point(Point point) {
        super(point.x, point.y);
        this.force = point.force;
    }

    public Point() {
    }

    public double getForce() {
        return this.force;
    }

    public boolean isValid() {
        return !(this.x < 0.0 || this.x > RobotBase.monRobot.myGetBattleFieldWidth() || this.y < 0.0) && !(this.y > RobotBase.monRobot.myGetBattleFieldHeight());
    }

    public double bearingTo(Point point) {
        return RobotMath.NormaliseHeading(Math.atan2(point.x - this.x, point.y - this.y));
    }

    public double bearingTo(double d, double d2) {
        return RobotMath.NormaliseHeading(Math.atan2(d - this.x, d2 - this.y));
    }

    public Point copyNextCircular(double d, double d2, double d3, double d4) {
        double d5;
        double d6;
        if (Math.abs(d3) > 1.0E-5) {
            double d7 = d / d3;
            double d8 = d4 * d3;
            d6 = this.y + Math.sin(d2 + d8) * d7 - Math.sin(d2) * d7;
            d5 = this.x + Math.cos(d2) * d7 - Math.cos(d2 + d8) * d7;
        } else {
            d6 = this.y + Math.cos(d2) * d * d4;
            d5 = this.x + Math.sin(d2) * d * d4;
        }
        return new Point(d5, d6, this.force);
    }

    public void nextCircular(double d, double d2, double d3, double d4) {
        if (Math.abs(d3) > 1.0E-5) {
            double d5 = d / d3;
            double d6 = d4 * d3;
            this.y = this.y + Math.sin(d2 + d6) * d5 - Math.sin(d2) * d5;
            this.x = this.x + Math.cos(d2) * d5 - Math.cos(d2 + d6) * d5;
        } else {
            this.y += Math.cos(d2) * d * d4;
            this.x += Math.sin(d2) * d * d4;
        }
    }

    public String toString() {
        return "< " + this.x + "; " + this.y + ">";
    }
}

