/*
 * Decompiled with CFR 0.152.
 */
package gre.svman4;

import gre.svman4.morfeas.EnemyState;
import gre.svman4.useful.FieldPoint;
import java.awt.geom.Line2D;
import robocode.util.Utils;

public class WaveBullet {
    public double bulletVelocity;
    public double directAngle;
    public double distanceToEnemyPosition;
    public double distanceTraveled = 0.0;
    public EnemyState enemy;
    public FieldPoint fireLocation;
    public long fireTime;
    public int lateralDirection;
    public int relativePosition;
    public double mineRobotVelocity;

    public static double limit(double min, double value, double max) {
        return Math.max(min, Math.min(value, max));
    }

    public double distanceFromCenterLine(FieldPoint point) {
        Line2D line = this.getShootingLine();
        return line.ptLineDist(point);
    }

    public double distanceSqFromCenterLine(FieldPoint point) {
        Line2D line = this.getShootingLine();
        return line.ptLineDistSq(point);
    }

    public int getFactorIndex(FieldPoint targetLocation) {
        double offsetAngle = this.fireLocation.getAngleTo(targetLocation) - this.directAngle;
        double factor = Utils.normalRelativeAngle((double)offsetAngle) / this.enemy.getMaxEscapeAngle(this.bulletVelocity) * (double)this.lateralDirection;
        return (int)WaveBullet.limit(0.0, factor * 30.0 + 30.0, 60.0);
    }

    public Line2D getShootingLine() {
        FieldPoint temp = this.fireLocation.project(this.distanceTraveled, this.directAngle);
        Line2D.Double line = new Line2D.Double();
        line.setLine(this.fireLocation, temp);
        return line;
    }
}

