/*
 * Decompiled with CFR 0.152.
 */
package lunchie;

import java.io.PrintStream;
import lunchie.MathUtils;
import lunchie.RobotInfo;
import robocode.AdvancedRobot;

public class Position {
    static final int POLAR = 10;
    static final int RECTANGULAR = 20;
    static double ArenaWidth = -1.0;
    static double ArenaHeight = -1.0;
    static double ArenaMaxDist = -1.0;
    private static AdvancedRobot robot;
    private boolean rectSet;
    private double x;
    private double y;
    private boolean polarSet;
    private double yThetaR;
    private double distance;

    public static void initialise(AdvancedRobot r) {
        robot = r;
        ArenaWidth = r.getBattleFieldWidth();
        ArenaHeight = r.getBattleFieldHeight();
        ArenaMaxDist = Math.sqrt(ArenaWidth * ArenaWidth + ArenaHeight * ArenaHeight);
    }

    private final void checkPolar() {
        if (!this.polarSet) {
            this.yThetaR = 1.5707963267948966 - Math.atan2(this.y, this.x);
            this.distance = Math.sqrt(this.x * this.x + this.y * this.y);
            this.polarSet = true;
        }
    }

    public double getYTheta() {
        this.checkPolar();
        return Math.toDegrees(this.yThetaR);
    }

    public double getYThetaR() {
        this.checkPolar();
        return this.yThetaR;
    }

    public double getDistance() {
        this.checkPolar();
        return this.distance;
    }

    private final void checkRectangular() {
        if (!this.rectSet) {
            this.x = MathUtils.sin(this.yThetaR) * this.distance;
            this.y = Math.cos(this.yThetaR) * this.distance;
            this.rectSet = true;
        }
    }

    public double getX() {
        this.checkRectangular();
        return this.x;
    }

    public double getY() {
        this.checkRectangular();
        return this.y;
    }

    public double getBearingRTo(Position other) {
        return this.getYThetaR() - other.getYThetaR();
    }

    public double getBearingTo(Position other) {
        return Math.toDegrees(this.getBearingRTo(other));
    }

    public Position getRelative(double headingR, double range) {
        Position other = new Position(RobotInfo.normaliseHeadingR(headingR), range, 10);
        other.offsetFor(this);
        return other;
    }

    public double getRangeTo(Position other) {
        double dx = Math.abs(other.getX() - this.getX());
        double dy = Math.abs(other.getY() - this.getY());
        return Math.sqrt(dx * dx + dy * dy);
    }

    public boolean isInArena() {
        return this.getX() >= 0.0 && this.getX() <= ArenaWidth && this.getY() >= 0.0 && this.getY() <= ArenaHeight;
    }

    public String toString() {
        return "[" + this.getX() + "," + this.getY() + "]" + " theta=" + this.getYTheta() + " dist=" + this.getDistance();
    }

    public void dump(PrintStream ostr) {
        ostr.print(this.toString());
    }

    private final void makeOrigin(Position offset) {
        this.x = this.getX() - offset.getX();
        this.y = this.getY() - offset.getY();
        this.rectSet = true;
        this.polarSet = false;
    }

    private final void offsetFor(Position offset) {
        this.x = this.getX() + offset.getX();
        this.y = this.getY() + offset.getY();
        this.rectSet = true;
        this.polarSet = false;
    }

    public Position() {
        this.x = robot.getX();
        this.y = robot.getY();
        this.rectSet = true;
        this.polarSet = false;
    }

    public Position(double alpha, double beta, int type) {
        if (type == 20) {
            this.x = alpha;
            this.y = beta;
            this.rectSet = true;
            this.polarSet = false;
        } else if (type == 10) {
            this.yThetaR = alpha;
            this.distance = beta;
            this.rectSet = false;
            this.polarSet = true;
        } else {
            System.out.println("ERROR: Bad params to Position CTOR(" + alpha + ", " + beta + ", " + type + ")");
        }
    }
}

