/*
 * Decompiled with CFR 0.152.
 */
package jmcd;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class VBullet {
    String targetName;
    int fireMethod;
    int distanceIndex;
    int offset;
    double originX;
    double originY;
    double absBearing;
    long time;
    double power;
    double minDistance;
    double errorAngle;

    public double distance(double now) {
        return (now - (double)this.time) * (20.0 - (double)3 * this.power);
    }

    public double getX(double now) {
        return this.originX + Math.sin(Math.toRadians(this.absBearing)) * this.distance(now);
    }

    public double getY(double now) {
        return this.originY + Math.cos(Math.toRadians(this.absBearing)) * this.distance(now);
    }

    public double range(double targetX, double targetY, double now) {
        double xo = targetX - this.getX(now);
        double yo = targetY - this.getY(now);
        return Math.sqrt(xo * xo + yo * yo);
    }

    public boolean targetWasHit(double targetX, double targetY, long now) {
        if (this.range(targetX, targetY, now) > 50.0) {
            return false;
        }
        double fraction = 0.0;
        while (fraction < 1.05) {
            if (this.range(targetX, targetY, (double)now - fraction) < 30.0) {
                return true;
            }
            fraction += 0.1;
        }
        return false;
    }

    public boolean outOfRange(double targetX, double targetY, long now) {
        double targetFromOrigin = Math.sqrt((targetX - this.originX) * (targetX - this.originX) + (targetY - this.originY) * (targetY - this.originY));
        return this.range(this.originX, this.originY, now) > targetFromOrigin + 30.0;
    }

    public double error(double targetX, double targetY, long now) {
        double currDistance = this.range(targetX, targetY, now);
        if (currDistance < Math.abs(this.minDistance)) {
            double THead = targetY - this.originY < 0.0 ? this.normalAbsoluteAngle(Math.toDegrees(Math.atan((targetX - this.originX) / (targetY - this.originY))) + 180.0) : this.normalAbsoluteAngle(Math.toDegrees(Math.atan((targetX - this.originX) / (targetY - this.originY))));
            this.errorAngle = this.normalRelativeAngle(THead - this.absBearing);
            this.minDistance = currDistance;
        }
        return this.errorAngle;
    }

    public double TrueAimAngle(double targetX, double targetY, long now) {
        double TargetDist;
        double TravelDist = this.range(this.originX, this.originY, now);
        if (TravelDist > (TargetDist = Math.sqrt((targetX - this.originX) * (targetX - this.originX) + (targetY - this.originY) * (targetY - this.originY))) - 30.0 && TravelDist < TargetDist + 50.0) {
            double TrueHead = this.getAbsAngle(this.originX, this.originY, targetX, targetY);
            return TrueHead;
        }
        if (TravelDist > TargetDist + 50.0) {
            return 999.9;
        }
        return -1.0;
    }

    public double normalAbsoluteAngle(double angle) {
        if (angle >= 0.0 && angle < 360.0) {
            return angle;
        }
        double fixedAngle = angle;
        while (fixedAngle < 0.0) {
            fixedAngle += 360.0;
        }
        while (fixedAngle >= 360.0) {
            fixedAngle -= 360.0;
        }
        return fixedAngle;
    }

    public double normalRelativeAngle(double angle) {
        if (angle > -180.0 && angle <= 180.0) {
            return angle;
        }
        double fixedAngle = angle;
        while (fixedAngle <= -180.0) {
            fixedAngle += 360.0;
        }
        while (fixedAngle > 180.0) {
            fixedAngle -= 360.0;
        }
        return fixedAngle;
    }

    public double getAbsAngle(double x0, double y0, double x1, double y1) {
        if (y1 == y0) {
            if (x1 == x0) {
                return this.absBearing;
            }
            if (x1 < x0) {
                return 270.0;
            }
            return 90.0;
        }
        if (y1 < y0) {
            return this.normalAbsoluteAngle(Math.toDegrees(Math.atan((x1 - x0) / (y1 - y0))) - 180.0);
        }
        return this.normalAbsoluteAngle(Math.toDegrees(Math.atan((x1 - x0) / (y1 - y0))));
    }

    private final /* synthetic */ void this() {
        this.minDistance = 10000.0;
        this.errorAngle = 0.0;
    }

    VBullet(String targetName, int distanceIndex, int fireMethod, int offset, double originX, double originY, double absBearing, long time, double power) {
        this.this();
        this.targetName = targetName;
        this.fireMethod = fireMethod;
        this.distanceIndex = distanceIndex;
        this.offset = offset;
        this.originX = originX;
        this.originY = originY;
        this.absBearing = absBearing;
        this.time = time;
        this.power = Math.max(0.1, Math.min((double)3, power));
    }
}

