/*
 * Decompiled with CFR 0.152.
 */
package apc.utils;

import apc.utils.EmData;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import robocode.AdvancedRobot;
import robocode.util.Utils;

public class HelperMethods {
    private static final double HALF_PI = 1.5707963267948966;
    private static final double TWO_PI = Math.PI * 2;
    private static final double BOT_HALF_WIDTH = 18.0;
    private static Rectangle2D.Double _rectangle = new Rectangle2D.Double(18.0, 18.0, 1164.0, 1164.0);
    private static double WALL_STICK = 140.0;

    public static double distanceSq(Point2D.Double myLocation, Point2D.Double botLocation) {
        double x = myLocation.x - botLocation.x;
        double y = myLocation.y - botLocation.y;
        double distance = Math.sqrt(x * x + y * y);
        return distance;
    }

    public static double bulletVelocity(double power) {
        return 20.0 - 3.0 * power;
    }

    public static double square(double d) {
        return d * d;
    }

    public static double cube(double d) {
        return d * d * d;
    }

    public static double power(double d, int exp) {
        double r = 1.0;
        int x = 0;
        while (x < exp) {
            r *= d;
            ++x;
        }
        return r;
    }

    public static Point2D.Double project(Point2D.Double sourceLocation, double sinAngle, double cosAngle, double length) {
        return new Point2D.Double(sourceLocation.x + sinAngle * length, sourceLocation.y + cosAngle * length);
    }

    public static double limit(double min, double value, double max) {
        return Math.max(min, Math.min(value, max));
    }

    public static double absoluteBearing(Point2D.Double sourceLocation, Point2D.Double target) {
        return Math.atan2(target.x - sourceLocation.x, target.y - sourceLocation.y);
    }

    public static double wallSmoothing(Point2D.Double botLocation, double angle, int orientation) {
        while (!_rectangle.contains(HelperMethods.project(botLocation, angle, WALL_STICK))) {
            angle += (double)orientation * 0.05;
        }
        return angle;
    }

    public static Point2D.Double project(Point2D.Double sourceLocation, double angle, double length) {
        return new Point2D.Double(sourceLocation.x + Math.sin(angle) * length, sourceLocation.y + Math.cos(angle) * length);
    }

    public static void setBackAsFront(AdvancedRobot robot, double goAngle) {
        double angle = Utils.normalRelativeAngle((double)(goAngle - robot.getHeadingRadians()));
        if (Math.abs(angle) > 1.5707963267948966) {
            if (angle < 0.0) {
                robot.setTurnRightRadians(Math.PI + angle);
            } else {
                robot.setTurnLeftRadians(Math.PI - angle);
            }
            robot.setBack(100.0);
        } else {
            if (angle < 0.0) {
                robot.setTurnLeftRadians(-1.0 * angle);
            } else {
                robot.setTurnRightRadians(angle);
            }
            robot.setAhead(100.0);
        }
    }

    public static int nonZeroSign(double d) {
        if (d < 0.0) {
            return -1;
        }
        return 1;
    }

    public static double maxEscapeAngle(double velocity) {
        return Math.asin(8.0 / velocity);
    }

    public static EmData findClosestEnemy(Collection<EmData> enemies) {
        EmData closestEnemy = new ArrayList<EmData>(enemies).get(0);
        for (EmData enemy : enemies) {
            if (!(closestEnemy.distance() > enemy.distance())) continue;
            closestEnemy = enemy;
        }
        return closestEnemy;
    }

    public static void removeEnemy(ArrayList<EmData> enemies, String name) {
        int count = 0;
        if (enemies.isEmpty()) {
            return;
        }
        for (EmData enemy : enemies) {
            if (name == enemy.name()) {
                enemies.remove(count);
                return;
            }
            ++count;
        }
    }

    public static EmData findWeakest(ArrayList<EmData> enemies) {
        int count = 0;
        if (enemies.isEmpty()) {
            return null;
        }
        EmData weakest = enemies.get(0);
        for (EmData enemy : enemies) {
            if (enemy.energy() < weakest.energy()) {
                weakest = enemy;
            }
            ++count;
        }
        System.out.println("Weakest " + weakest.name());
        return weakest;
    }
}

