/*
 * Decompiled with CFR 0.152.
 */
package gun;

import gun.BulletVector;
import gun.enemyGunSim;
import gun.vGunAngle;
import java.awt.Color;
import java.awt.Graphics2D;
import java.util.LinkedList;
import java.util.concurrent.ConcurrentHashMap;
import origin.Aim;
import origin.Enemy;
import origin.SleepSiphon;
import origin.Util;
import origin.WeightedPoint;
import robocode.Rules;
import util.TimedPoint;

public class VirtualAngleGuns {
    private static final int numGuns = 4;
    private ConcurrentHashMap<String, Enemy> enemyMap;
    private SleepSiphon self;
    private LinkedList<WeightedPoint> vBulletLocs = new LinkedList();

    public VirtualAngleGuns(SleepSiphon s, ConcurrentHashMap<String, Enemy> e) {
        this.self = s;
        this.enemyMap = e;
    }

    public void updateEnemy(Enemy target) {
        long currentTime = this.self.getTime();
        long scanTime = target.getTime();
        if (scanTime == currentTime) {
            boolean enemyDataExistsNOW = true;
            int[] bulletSuccess = new int[4];
            LinkedList<BulletVector> vBullets = target.getVirtualAngleBulletsSet();
            int i = 0;
            while (i < vBullets.size()) {
                BulletVector cBulletVector = vBullets.get(i);
                double rad = cBulletVector.getLengthAtTime(currentTime);
                double eDistFromBulletStart = cBulletVector.getStartPos().distance(target.getPosition());
                WeightedPoint projectedBulletLoc = new WeightedPoint(cBulletVector.projectByRad(rad));
                double cWeight = 0.1;
                if (Util.withinTolerance(rad, eDistFromBulletStart, 18.0)) {
                    target.updateGunStat(enemyGunSim.checkForHit(projectedBulletLoc, target), cBulletVector.getGunID());
                    cWeight += 0.9;
                }
                this.vBulletLocs.add(projectedBulletLoc);
                projectedBulletLoc.setWeight(cWeight);
                if (projectedBulletLoc.getWeight() == 1.0 || cBulletVector.getAge(currentTime) > 100L) {
                    vBullets.remove(cBulletVector);
                    --i;
                }
                ++i;
            }
        }
    }

    public void updateAll() {
        this.vBulletLocs = new LinkedList();
        for (Enemy enemy : this.enemyMap.values()) {
            this.updateEnemy(enemy);
        }
    }

    public void virtualFireAll() {
        for (Enemy enemy : this.enemyMap.values()) {
            this.virtualFire(enemy);
        }
    }

    private void virtualFire(Enemy target) {
        LinkedList<BulletVector> vBullets = target.getVirtualAngleBulletsSet();
        int i = 0;
        while (i < 4) {
            vBullets.add(this.virtualGunOutput(target, i));
            ++i;
        }
    }

    private BulletVector virtualGunOutput(Enemy target, int gunID) {
        long currentTime = this.self.getTime();
        double BULLET_POWER = Aim.firePowerByDist(this.self, target);
        double BULLET_SPEED = Rules.getBulletSpeed((double)BULLET_POWER);
        TimedPoint selfTimedPos = new TimedPoint(this.self.getX(), this.self.getY(), currentTime);
        BulletVector bulletVector = null;
        switch (gunID) {
            case 0: {
                bulletVector = new BulletVector(selfTimedPos, vGunAngle.headOn(selfTimedPos, target, BULLET_POWER), BULLET_SPEED, gunID);
                break;
            }
            case 1: {
                bulletVector = new BulletVector(selfTimedPos, vGunAngle.linearPredictionFire(selfTimedPos, target, BULLET_POWER), BULLET_SPEED, gunID);
                break;
            }
            case 2: {
                bulletVector = new BulletVector(selfTimedPos, vGunAngle.constantTurnPredict(selfTimedPos, target, BULLET_POWER), BULLET_SPEED, gunID);
                break;
            }
            case 3: {
                bulletVector = new BulletVector(selfTimedPos, vGunAngle.averageMovementGun(selfTimedPos, target, BULLET_POWER), BULLET_SPEED, gunID);
            }
        }
        return bulletVector;
    }

    public void onPaint(Graphics2D g, boolean enabled) {
        if (enabled) {
            g.setColor(new Color(255, 20, 20, 185));
            int count = 0;
            int totalBullets = this.vBulletLocs.size();
            int rad = 6;
            for (WeightedPoint c : this.vBulletLocs) {
                Color rgb = new Color(Color.HSBtoRGB((float)((double)count / (double)totalBullets), 1.0f, 1.0f));
                Color rgba = new Color(rgb.getRed(), rgb.getGreen(), rgb.getBlue(), (int)(c.getWeight() * 255.0));
                g.setColor(rgba);
                g.fillOval((int)c.getX() - 3, (int)c.getY() - 3, 6, 6);
                ++count;
            }
        }
    }
}

