/*
 * Decompiled with CFR 0.152.
 */
package dk.tactics;

import dk.Base;
import dk.tactics.Aggregate;
import dk.tactics.BasicDuel;
import dk.tactics.BasicMelee;
import dk.tactics.Tactics;
import robocode.Robot;

public class MeleeBlend
extends Aggregate {
    protected static final int MODE_MELEE = 0;
    protected static final int MODE_DUEL = 1;
    private int mode = 0;
    private Tactics meleeTactic;
    private Tactics duelTactic;

    public MeleeBlend() {
        this(new BasicMelee(), new BasicDuel());
    }

    public MeleeBlend(Tactics melee, Tactics duel) {
        this.meleeTactic = melee;
        this.duelTactic = duel;
    }

    public void doStartRound(Base robot) {
        this.addTactic(this.meleeTactic);
        this.mode = 0;
        super.doStartRound(robot);
    }

    public void doTurn(Base robot) {
        if (this.mode == 0 && robot.getOthers() <= robot.config.MAX_ROBOTS_DUEL) {
            ((Robot)robot).out.println("switching to duel mode");
            this.clearTactics();
            this.addTactic(this.duelTactic);
            this.duelTactic.doStartRound(robot);
            this.mode = 1;
        }
        super.doTurn(robot);
    }
}

