/*
 * Decompiled with CFR 0.152.
 */
package pa3k;

import java.util.Iterator;
import pa3k.Log;
import pa3k.Opponent;
import pa3k.OpponentCreator;
import pa3k.Position;
import pa3k.SelfTracking;
import pa3k.Tracking;
import robocode.AdvancedRobot;
import robocode.Robot;
import robocode.Rules;
import robocode.util.Utils;

public class GlobalTracking
extends Tracking {
    public GlobalTracking(AdvancedRobot robot, SelfTracking selfTracking, OpponentCreator oc) {
        super(robot, selfTracking, oc);
    }

    @Override
    public void turn() {
        long ct = this.robot.getTime();
        Iterator i = this.opponents.values().iterator();
        int knownCount = 0;
        Opponent hp = null;
        while (i.hasNext()) {
            Opponent o = (Opponent)i.next();
            if (o.getScanPriority(ct) != -1) {
                ++knownCount;
            }
            if (hp != null && hp.getScanPriority(ct) >= o.getScanPriority(ct)) continue;
            hp = o;
        }
        Log.log(4, "Known count = " + knownCount);
        if (this.robot.getOthers() > knownCount) {
            this.robot.setTurnRadarRightRadians(Rules.RADAR_TURN_RATE_RADIANS);
        } else {
            Position p = new Position((Robot)this.robot);
            double d = Utils.normalRelativeAngle((double)(p.getDirectionTo(hp.getLastPosition()) - this.robot.getRadarHeadingRadians()));
            double angle = Rules.RADAR_TURN_RATE_RADIANS;
            if (knownCount == 1) {
                double maxD = Math.abs(d) + Rules.RADAR_TURN_RATE_RADIANS / 2.0;
                if (Math.abs(angle) > maxD) {
                    angle = maxD;
                }
            }
            if (d > 0.0) {
                this.robot.setTurnRadarRightRadians(angle);
            } else {
                this.robot.setTurnRadarLeftRadians(angle);
            }
        }
        this.turnBulletTracking();
    }
}

