/*
 * Decompiled with CFR 0.152.
 */
package vuen.fractal.util;

public class BotMath {
    public static double arenawidth;
    public static double arenaheight;
    public static final double WALL_ADJUST = 0.0;

    private BotMath() {
    }

    public static double distancePoints(double x1, double y1, double x2, double y2) {
        return Math.sqrt(Math.pow(x1 - x2, 2.0) + Math.pow(y1 - y2, 2.0));
    }

    public static double anglePoints(double x1, double y1, double x2, double y2) {
        return Math.toDegrees(Math.atan2(x1 - x2, y1 - y2));
    }

    public static double angleVector(double x, double y) {
        return BotMath.anglePoints(x, y, 0.0, 0.0);
    }

    public static double hypotenuse(double x, double y) {
        return Math.sqrt(Math.pow(x, 2.0) + Math.pow(y, 2.0));
    }

    public static double normalAbsoluteAngle(double angle) {
        return (angle + 1080.0) % 360.0;
    }

    public static double normalRelativeAngle(double angle) {
        return (angle + 900.0) % 360.0 - 180.0;
    }

    public static double normalRelativeAngleRadians(double angle) {
        return Math.toRadians(BotMath.normalRelativeAngle(Math.toDegrees(angle)));
    }

    public static double normalPerpendicularAngle(double angle) {
        return (angle + 450.0) % 180.0 - 90.0;
    }

    public static boolean isHeadingWall(double cx, double cy, double heading) {
        double x = cx + Math.sin(Math.toRadians(heading)) * 18.0;
        double y = cy + Math.cos(Math.toRadians(heading)) * 18.0;
        x += BotMath.sign(x) * 0.0;
        y += BotMath.sign(y) * 0.0;
        return x < 19.0 || y < 19.0 || x > arenawidth - 19.0 || y > arenaheight - 19.0;
    }

    public static boolean isFacingWall(double heading, double wall) {
        return Math.abs(BotMath.normalRelativeAngle(heading - wall)) < 90.0;
    }

    public static double findCrashWall(double x, double y, double heading) {
        double junk;
        if (BotMath.isFacingWall(heading, 0.0) && (junk = x - (y - arenaheight) / BotMath.tan(90.0 - heading)) >= 0.0 && junk <= arenawidth) {
            return 0.0;
        }
        if (BotMath.isFacingWall(heading, 90.0) && (junk = y - (x - arenawidth) * BotMath.tan(90.0 - heading)) >= 0.0 && junk <= arenaheight) {
            return 90.0;
        }
        if (BotMath.isFacingWall(heading, 180.0) && (junk = x - y / BotMath.tan(90.0 - heading)) >= 0.0 && junk <= arenawidth) {
            return 180.0;
        }
        if (BotMath.isFacingWall(heading, -90.0) && (junk = y - x * BotMath.tan(90.0 - heading)) >= 0.0 && junk <= arenaheight) {
            return -90.0;
        }
        throw new NullPointerException("Unable to intersect wall!");
    }

    public static double findOtherFacingWall(double x, double y, double heading) {
        double wall = BotMath.findCrashWall(x, y, heading);
        for (double i = 0.0; i < 360.0; i += 90.0) {
            if (!BotMath.isFacingWall(heading, i) || wall == i) continue;
            return i;
        }
        throw new NullPointerException("Unable to find second crashing wall! First wall: " + Math.round(wall));
    }

    public static double distanceNormalClosestWall(double x, double y) {
        double distance = 100000.0;
        if (x < distance) {
            distance = x;
        }
        if (arenawidth - x < distance) {
            distance = arenawidth - x;
        }
        if (y < distance) {
            distance = y;
        }
        if (arenaheight - y < distance) {
            distance = arenaheight - y;
        }
        return distance - 0.0;
    }

    public static double distanceNormalWall(double x, double y, double wall) {
        if (BotMath.normalRelativeAngle(Math.round(wall)) == 0.0) {
            return arenaheight - y - 0.0;
        }
        if (BotMath.normalRelativeAngle(Math.round(wall)) == 90.0) {
            return arenawidth - x - 0.0;
        }
        if (BotMath.normalRelativeAngle(Math.round(wall)) == -180.0) {
            return y - 0.0;
        }
        if (BotMath.normalRelativeAngle(Math.round(wall)) == -90.0) {
            return x - 0.0;
        }
        throw new RuntimeException("Unable to match requested wall! Wall: " + Math.round(wall));
    }

    public static double distanceWall(double x, double y, double heading, double wall) {
        if (BotMath.normalRelativeAngle(Math.round(wall)) == 0.0) {
            return BotMath.distancePoints(x, y, x - (y - arenaheight) / BotMath.tan(90.0 - heading), arenaheight) - 0.0;
        }
        if (BotMath.normalRelativeAngle(Math.round(wall)) == 90.0) {
            return BotMath.distancePoints(x, y, arenaheight, y - (x - arenawidth) * BotMath.tan(90.0 - heading)) - 0.0;
        }
        if (BotMath.normalRelativeAngle(Math.round(wall)) == -180.0) {
            return BotMath.distancePoints(x, y, x - y / BotMath.tan(90.0 - heading), 0.0) - 0.0;
        }
        if (BotMath.normalRelativeAngle(Math.round(wall)) == -90.0) {
            return BotMath.distancePoints(x, y, 0.0, y - x * BotMath.tan(90.0 - heading)) - 0.0;
        }
        throw new NullPointerException("Unable to intersect wall!  " + BotMath.normalRelativeAngle(wall));
    }

    public static double sign(double val) {
        if (val > 0.0) {
            return 1.0;
        }
        if (val < 0.0) {
            return -1.0;
        }
        return 0.0;
    }

    public static double unsign(double val) {
        if (val < 0.0) {
            return -1.0;
        }
        return 1.0;
    }

    public static double bound(double val) {
        return Math.max(Math.min(val, 1.0), 0.0);
    }

    public static double cap(double val, double min, double max) {
        return Math.max(Math.min(val, max), min);
    }

    public static int cap(int val, int min, int max) {
        return Math.max(Math.min(val, max), min);
    }

    public static double uncap(double val, double min, double max) {
        if (val < min || val > max) {
            return -1.0;
        }
        return val;
    }

    public static int uncap(int val, int min, int max) {
        if (val < min || val > max) {
            return -1;
        }
        return val;
    }

    public static double round(double val, int digits) {
        return (double)Math.round(val * Math.pow(10.0, digits)) / Math.pow(10.0, digits);
    }

    public static double geometricabs(double val) {
        if (val < 1.0) {
            return 1.0 / val;
        }
        return val;
    }

    public static double tan(double theta) {
        return Math.tan(Math.toRadians(theta));
    }
}

