/*
 * Decompiled with CFR 0.152.
 */
package jwirde;

import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import jwirde.Environment;
import jwirde.GravityMovement;
import jwirde.Gun;
import jwirde.LinearGun;
import jwirde.LockedRadar;
import jwirde.MovementStrategy;
import jwirde.Radar;
import jwirde.StrafingMovement;
import jwirde.SweepRadar;
import robocode.AdvancedRobot;

public class AIStrategy {
    private final Random myRandom = new Random();
    private final AdvancedRobot myRobot;
    private final Environment env;
    private final Map<String, Gun> guns = new HashMap<String, Gun>();
    private final MovementStrategy meleeMovement;
    private final MovementStrategy oneOnOneMovement;
    private final Radar meleeRadar;
    private final Radar oneOnOneRadar;

    public AIStrategy(AdvancedRobot myRobot, Environment env) {
        this.myRobot = myRobot;
        this.env = env;
        LinearGun linearGun = new LinearGun(myRobot);
        this.guns.put(linearGun.getName(), linearGun);
        this.meleeMovement = new GravityMovement(myRobot, env);
        this.oneOnOneMovement = new StrafingMovement(myRobot, env);
        this.meleeRadar = new SweepRadar(myRobot);
        this.oneOnOneRadar = new LockedRadar(myRobot, env);
    }

    public Gun gunByName(String gunName) {
        if (gunName == null) {
            return (Gun)this.guns.values().toArray()[this.myRandom.nextInt(this.guns.size())];
        }
        return this.guns.get(gunName);
    }

    public MovementStrategy selectMovementStrategy() {
        if (this.myRobot.getOthers() > 1) {
            return this.meleeMovement;
        }
        return this.oneOnOneMovement;
    }

    public Radar selectRadarStrategy() {
        if (this.myRobot.getOthers() > 1) {
            return this.meleeRadar;
        }
        return this.oneOnOneRadar;
    }
}

